/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.buri.oouo.internal.structure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.seasar.buri.common.util.MultiValueMap;
import org.seasar.buri.oouo.internal.structure.BuriActivitySetType;
import org.seasar.buri.oouo.internal.structure.BuriActivityType;
import org.seasar.buri.oouo.internal.structure.BuriApplicationType;
import org.seasar.buri.oouo.internal.structure.BuriDataFieldType;
import org.seasar.buri.oouo.internal.structure.BuriExtendedAttributeType;
import org.seasar.buri.oouo.internal.structure.BuriPackageType;
import org.seasar.buri.oouo.internal.structure.BuriParticipantType;
import org.seasar.buri.oouo.internal.structure.BuriTransitionType;

public class BuriWorkflowProcessType {
    private String id;
    private String name;
    private Map rolesId = new HashMap();
    private MultiValueMap rolesName = new MultiValueMap();
    private Map data = new HashMap();
    private Map applicationId = new HashMap();
    private MultiValueMap applicationName = new MultiValueMap();
    private Map activityById = new HashMap();
    private MultiValueMap activityByName = new MultiValueMap();
    private List transition = new ArrayList();
    private MultiValueMap transitionByFrom = new MultiValueMap();
    private MultiValueMap transitionByTo = new MultiValueMap();
    private List startActivitys = new ArrayList();
    private List ExtentedAttribute = new ArrayList();
    private Map activitySetId = new HashMap();
    private BuriPackageType packageType;
    private long pathType = 0L;
    public static final String OOUOTHIS = "WorkflowProcess";
    public static final String setId_ATTRI = "Id";
    public static final String setName_ATTRI = "Name";
    public static final String addRoles_ELEMENT = "Participant";
    public static final String addApplication_ELEMENT = "Application";
    public static final String addDataField_ELEMENT = "DataField";
    public static final String addExtendedAttribute_ELEMENT = "ExtendedAttribute";
    public static final String addActivity_ELEMENT = "Activity";
    public static final String addTransition_ELEMENT = "Transition";
    public static final String addActivitySet_ELEMENT = "ActivitySet";
    public static String setupEnd_OOUOFIN = "";

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addRoles(BuriParticipantType participant) {
        this.rolesId.put(participant.getId(), participant);
        this.rolesName.put(participant.getName(), participant);
    }

    public List getRolesByName(String roleName) {
        return this.rolesName.get(roleName);
    }

    public BuriParticipantType getRolesById(String roleId) {
        if (this.rolesId.containsKey(roleId)) {
            return (BuriParticipantType)this.rolesId.get(roleId);
        }
        return this.packageType.getRolesById(roleId);
    }

    public void addApplication(BuriApplicationType app) {
        this.applicationId.put(app.getId(), app);
        this.applicationName.put(app.getName(), app);
    }

    public BuriApplicationType getApplicationById(String appId) {
        if (this.applicationId.containsKey(appId)) {
            return (BuriApplicationType)this.applicationId.get(appId);
        }
        return this.packageType.getApplicationById(appId);
    }

    public List getApplicationByName(String appName) {
        return this.applicationName.get(appName);
    }

    public void addDataField(BuriDataFieldType dataField) {
        this.data.put(dataField.getId(), dataField);
    }

    public BuriDataFieldType getDataFieldById(String dataId) {
        if (this.data.containsKey(dataId)) {
            return (BuriDataFieldType)this.data.get(dataId);
        }
        return this.packageType.getDataFieldById(dataId);
    }

    public Map getDataField() {
        return this.data;
    }

    public void addExtendedAttribute(BuriExtendedAttributeType attri) {
        this.ExtentedAttribute.add(attri);
    }

    public List getExtentedAttribute() {
        return this.ExtentedAttribute;
    }

    public void addActivity(BuriActivityType act) {
        this.activityById.put(act.getId(), act);
        this.activityByName.put(act.getName(), act);
    }

    public BuriActivityType getActivityById(String actId) {
        return (BuriActivityType)this.activityById.get(actId);
    }

    public List getActivityByName(String actName) {
        return this.activityByName.get(actName);
    }

    public Map getActivityById() {
        return this.activityById;
    }

    public void addTransition(BuriTransitionType transition) {
        this.transition.add(transition);
        this.transitionByFrom.put(transition.getFrom(), transition);
        this.transitionByTo.put(transition.getTo(), transition);
    }

    public List getRefToTransition(String actId) {
        if (this.transitionByTo.containsKey(actId)) {
            return this.transitionByTo.get(actId);
        }
        return new ArrayList();
    }

    public List getRefFromTransition(String actId) {
        if (this.transitionByFrom.containsKey(actId)) {
            return this.transitionByFrom.get(actId);
        }
        return new ArrayList();
    }

    public void addActivitySet(BuriActivitySetType activitySet) {
        this.activitySetId.put(activitySet.getId(), activitySet);
    }

    public BuriActivitySetType getActivitySet(String actId) {
        return (BuriActivitySetType)this.activitySetId.get(actId);
    }

    public void setupEnd(BuriPackageType packageType) {
        this.packageType = packageType;
        this.updateStartActivites();
    }

    public BuriPackageType getPackageType() {
        return this.packageType;
    }

    public void setPackageType(BuriPackageType packageType) {
        this.packageType = packageType;
        this.updateStartActivites();
    }

    protected void updateStartActivites() {
        ArrayList actIds = new ArrayList(this.activityById.keySet());
        actIds.removeAll(this.transitionByTo.keySet());
        Iterator ite = actIds.iterator();
        while (ite.hasNext()) {
            String id = (String)ite.next();
            BuriActivityType act = this.getActivityById(id);
            this.startActivitys.add(act);
        }
    }

    public List getStartActivitys() {
        return this.startActivitys;
    }

    public long getPathType() {
        return this.pathType;
    }

    public void setPathType(long pathType) {
        this.pathType = pathType;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("[");
        buff.append("  id=").append(this.id);
        buff.append("/name=").append(this.name);
        buff.append("/pathType=").append(this.pathType).append("\n");
        buff.append("  -----ROLE ID----------\n");
        buff.append("  /roles=").append(this.rolesId).append("\n");
        buff.append("  -----DATA----------\n");
        buff.append("  /data=").append(this.data).append("\n");
        buff.append("  -----APPLICATION----------\n");
        buff.append("  /application=").append(this.applicationId).append("\n");
        buff.append("  -----ACTIVITY----------\n");
        buff.append("  /activity=").append(this.activityById).append("\n");
        buff.append("  -----ACTIVITY SET----------\n");
        buff.append("  /activitySetId=").append(this.activitySetId).append("\n");
        buff.append("  -----transition----------\n");
        buff.append("  /transition=").append(this.transition).append("\n");
        buff.append("  -----ExtentedAttribute----------\n");
        buff.append("  /ExtentedAttribute=").append(this.ExtentedAttribute).append("\n");
        buff.append("  -----START ACTIVITY----------\n");
        buff.append("  /").append(this.startActivitys).append("\n");
        buff.append("]\n\n");
        return buff.toString();
    }
}

