/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import common.Assert;
import jxl.WorkbookSettings;
import jxl.biff.ByteData;
import jxl.biff.IndexMapping;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.drawing.EscherContainer;
import jxl.biff.drawing.EscherRecordData;
import jxl.biff.drawing.EscherRecordType;
import jxl.biff.drawing.EscherStream;
import jxl.biff.drawing.MsoDrawingRecord;
import jxl.biff.drawing.ObjRecord;
import jxl.biff.drawing.SpContainer;
import jxl.read.biff.File;

public class Chart
implements ByteData,
EscherStream {
    private MsoDrawingRecord msoDrawingRecord;
    private ObjRecord objRecord;
    private int startpos;
    private int endpos;
    private File file;
    private byte[] data;
    private boolean initialized;
    private WorkbookSettings workbookSettings;

    public Chart(MsoDrawingRecord mso, ObjRecord obj, int sp, int ep, File f, WorkbookSettings ws) {
        this.msoDrawingRecord = mso;
        this.objRecord = obj;
        this.startpos = sp;
        this.endpos = ep;
        this.file = f;
        this.workbookSettings = ws;
        this.initialized = false;
        Assert.verify(mso != null && obj != null || mso == null && obj == null);
    }

    public byte[] getBytes() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.data;
    }

    public byte[] getData() {
        return this.msoDrawingRecord.getRecord().getData();
    }

    private void initialize() {
        this.data = this.file.read(this.startpos, this.endpos - this.startpos);
        this.initialized = true;
    }

    public void rationalize(IndexMapping xfMapping, IndexMapping fontMapping, IndexMapping formatMapping) {
        if (!this.initialized) {
            this.initialize();
        }
        int code = 0;
        int length = 0;
        Type type = null;
        for (int pos = 0; pos < this.data.length; pos += length + 4) {
            int fontind;
            code = IntegerHelper.getInt(this.data[pos], this.data[pos + 1]);
            length = IntegerHelper.getInt(this.data[pos + 2], this.data[pos + 3]);
            type = Type.getType(code);
            if (type == Type.FONTX) {
                fontind = IntegerHelper.getInt(this.data[pos + 4], this.data[pos + 5]);
                IntegerHelper.getTwoBytes(fontMapping.getNewIndex(fontind), this.data, pos + 4);
                continue;
            }
            if (type == Type.FBI) {
                fontind = IntegerHelper.getInt(this.data[pos + 12], this.data[pos + 13]);
                IntegerHelper.getTwoBytes(fontMapping.getNewIndex(fontind), this.data, pos + 12);
                continue;
            }
            if (type != Type.IFMT) continue;
            int formind = IntegerHelper.getInt(this.data[pos + 4], this.data[pos + 5]);
            IntegerHelper.getTwoBytes(formatMapping.getNewIndex(formind), this.data, pos + 4);
        }
    }

    SpContainer getSpContainer() {
        EscherRecordData er = new EscherRecordData(this, 0);
        Assert.verify(er.isContainer());
        EscherContainer escherData = new EscherContainer(er);
        SpContainer spContainer = null;
        if (escherData.getType() == EscherRecordType.DG_CONTAINER) {
            EscherRecordData erd = new EscherRecordData(this, 80);
            Assert.verify(erd.getType() == EscherRecordType.SP_CONTAINER);
            spContainer = new SpContainer(erd);
        } else {
            Assert.verify(escherData.getType() == EscherRecordType.SP_CONTAINER);
            spContainer = new SpContainer(er);
        }
        return spContainer;
    }

    MsoDrawingRecord getMsoDrawingRecord() {
        return this.msoDrawingRecord;
    }

    ObjRecord getObjRecord() {
        return this.objRecord;
    }
}

