/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.composer.exporter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jiemamy.JiemamyContext;
import org.jiemamy.composer.ExportException;
import org.jiemamy.composer.FileExporter;
import org.jiemamy.composer.exporter.SimpleSqlExportConfig;
import org.jiemamy.composer.exporter.SqlExportConfig;
import org.jiemamy.dialect.Dialect;
import org.jiemamy.dialect.EmitConfig;
import org.jiemamy.dialect.SqlEmitter;
import org.jiemamy.model.ModelConsistencyException;
import org.jiemamy.model.sql.SqlStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlExporter
extends FileExporter<SqlExportConfig> {
    public static final String OVERWRITE = "overwrite";
    public static final String OUTPUT_FILE = "outputFile";
    public static final String DATA_SET_INDEX = "dataSetIndex";
    public static final String DROP = "emitDropStatements";
    public static final String SCHEMA = "emitCreateSchemaStatement";

    public boolean exportModel(JiemamyContext context, SqlExportConfig config) throws ExportException {
        Validate.notNull((Object)context);
        Validate.notNull((Object)config);
        OutputStreamWriter writer = null;
        try {
            boolean mkdirResult;
            File parentDir;
            Dialect dialect = context.findDialect();
            SqlEmitter emitter = dialect.getSqlEmitter();
            List statements = emitter.emit(context, (EmitConfig)config);
            File outputFile = config.getOutputFile();
            if (outputFile == null) {
                outputFile = this.getDefaultOutputFile();
            }
            if (outputFile.exists()) {
                if (!config.isOverwrite()) {
                    boolean bl = false;
                    return bl;
                }
                if (!outputFile.delete()) {
                    throw new ExportException("Cannot delete file: " + outputFile.getAbsolutePath());
                }
            }
            if ((parentDir = outputFile.getParentFile()) != null && !parentDir.exists() && !(mkdirResult = parentDir.mkdir())) {
                throw new ExportException("Cannot create directory: " + parentDir.getAbsolutePath());
            }
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8");
            for (SqlStatement stmt : statements) {
                writer.write(stmt.toString());
                writer.write(SystemUtils.LINE_SEPARATOR);
            }
            IOUtils.closeQuietly((Writer)writer);
        }
        catch (IOException e) {
            throw new ExportException((Exception)e);
        }
        catch (ClassNotFoundException e) {
            throw new ExportException("Dialect not found.", (Exception)e);
        }
        catch (ModelConsistencyException e) {
            throw new ExportException("This model is inconsistent.", (Exception)((Object)e));
        }
        catch (UnsupportedOperationException e) {
            throw new ExportException("This dialect does not support export SQL.", (Exception)e);
        }
        finally {
            IOUtils.closeQuietly(writer);
        }
        return true;
    }

    public String getName() {
        return "SQL Exporter";
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)((Object)this), (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    protected File getDefaultOutputFile() {
        return new File("./target/exported.jiemamy");
    }

    protected SqlExportConfig newSimpleConfigInstance() {
        return new SimpleSqlExportConfig();
    }
}

