/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.serializer.stax;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.validation.Validatable;
import org.codehaus.stax2.validation.XMLValidationSchema;
import org.codehaus.stax2.validation.XMLValidationSchemaFactory;
import org.codehaus.staxmate.SMInputFactory;
import org.codehaus.staxmate.SMOutputFactory;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.out.SMOutputContext;
import org.codehaus.staxmate.out.SMOutputDocument;
import org.jiemamy.FacetProvider;
import org.jiemamy.JiemamyContext;
import org.jiemamy.JiemamyFacet;
import org.jiemamy.serializer.JiemamySerializer;
import org.jiemamy.serializer.SerializationException;
import org.jiemamy.serializer.stax.DeserializationContext;
import org.jiemamy.serializer.stax.SerializationContext;
import org.jiemamy.serializer.stax.StaxDirector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiemamyStaxSerializer
implements JiemamySerializer {
    private boolean validate = true;

    @Override
    public JiemamyContext deserialize(InputStream in, FacetProvider ... facetProviders) throws SerializationException {
        Validate.notNull((Object)in);
        Validate.noNullElements((Object[])facetProviders);
        JiemamyContext context = new JiemamyContext(facetProviders);
        SMHierarchicCursor cursor = null;
        SMInputFactory inFactory = new SMInputFactory(XMLInputFactory.newInstance());
        try {
            cursor = inFactory.rootElementCursor(in);
            XMLStreamReader2 streamReader = cursor.getStreamReader();
            this.setValidators((Validatable)streamReader, context.getFacets());
            DeserializationContext dctx = new DeserializationContext(context, cursor);
            StaxDirector director = new StaxDirector(context);
            cursor.advance();
            director.direct(dctx);
        }
        catch (XMLStreamException e) {
            throw new SerializationException(e);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.getStreamReader().closeCompletely();
                }
                catch (XMLStreamException e) {}
            }
        }
        return context;
    }

    public boolean isValidate() {
        return this.validate;
    }

    @Override
    public void serialize(JiemamyContext context, OutputStream out) throws SerializationException {
        Validate.notNull((Object)context);
        Validate.notNull((Object)out);
        SMOutputDocument doc = null;
        SMOutputFactory outFactory = new SMOutputFactory(XMLOutputFactory.newInstance());
        XMLStreamWriter2 writer = null;
        try {
            writer = outFactory.createStax2Writer(out);
            this.setValidators((Validatable)writer, context.getFacets());
            doc = SMOutputContext.createInstance((XMLStreamWriter2)writer).createDocument();
            doc.setIndentation("\n" + StringUtils.repeat((String)"  ", (int)100), 1, 2);
            SerializationContext ctx = new SerializationContext(context, doc);
            StaxDirector director = new StaxDirector(context);
            director.direct(context, ctx);
        }
        catch (XMLStreamException e) {
            throw new SerializationException(e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (XMLStreamException e) {}
            }
        }
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    private void setValidators(Validatable validatable, Set<JiemamyFacet> facets) throws XMLStreamException {
        if (!this.validate) {
            return;
        }
        XMLValidationSchemaFactory sf = XMLValidationSchemaFactory.newInstance((String)"http://www.w3.org/2001/XMLSchema");
        XMLValidationSchema vs = sf.createSchema(JiemamyStaxSerializer.class.getResource("/jiemamy-core.xsd"));
        validatable.validateAgainst(vs);
        for (JiemamyFacet facet : facets) {
            URL schema = facet.getSchema();
            if (schema == null) continue;
            XMLValidationSchema fvs = sf.createSchema(schema);
            validatable.validateAgainst(fvs);
        }
    }
}

