/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.dialect;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.jiemamy.dialect.Dialect;
import org.jiemamy.dialect.Necessity;
import org.jiemamy.model.datatype.RawTypeCategory;
import org.jiemamy.model.datatype.RawTypeDescriptor;
import org.jiemamy.model.datatype.SimpleRawTypeDescriptor;
import org.jiemamy.model.datatype.TypeParameterKey;
import org.jiemamy.validator.StandardValidator;
import org.jiemamy.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDialect
implements Dialect {
    private final String connectionUriTemplate;
    private final List<Entry> typeEntries;

    public AbstractDialect(String connectionUriTemplate, List<Entry> typeEntries) {
        Validate.notNull((Object)connectionUriTemplate);
        Validate.noNullElements(typeEntries);
        this.connectionUriTemplate = connectionUriTemplate;
        this.typeEntries = ImmutableList.copyOf(typeEntries);
    }

    @Override
    public List<RawTypeDescriptor> getAllRawTypeDescriptors() {
        return Lists.transform(this.typeEntries, (Function)new Function<Entry, RawTypeDescriptor>(){

            public RawTypeDescriptor apply(Entry from) {
                return from.descriptor;
            }
        });
    }

    @Override
    public String getConnectionUriTemplate() {
        return this.connectionUriTemplate;
    }

    public List<Entry> getTypeEntries() {
        return Lists.newArrayList(this.typeEntries);
    }

    @Override
    public Map<TypeParameterKey<?>, Necessity> getTypeParameterSpecs(RawTypeDescriptor reference) {
        RawTypeDescriptor normalized = this.normalize(reference);
        if (normalized.getCategory() == RawTypeCategory.UNKNOWN) {
            return Collections.emptyMap();
        }
        for (Entry typeEntry : this.typeEntries) {
            if (!typeEntry.descriptor.equals(normalized)) continue;
            return Maps.newHashMap((Map)typeEntry.typeParameterSpecs);
        }
        throw new Error(reference.toString());
    }

    @Override
    public Validator getValidator() {
        return new StandardValidator();
    }

    @Override
    public final RawTypeDescriptor normalize(RawTypeDescriptor in) {
        RawTypeDescriptor result = this.normalize0(in);
        assert (result.getCategory() == RawTypeCategory.UNKNOWN || this.getAllRawTypeDescriptors().contains(result)) : result.toString();
        return result;
    }

    protected RawTypeDescriptor normalize0(RawTypeDescriptor in) {
        for (Entry typeEntry : this.typeEntries) {
            if (!typeEntry.getDescriptor().equals(in)) continue;
            return in;
        }
        if (in.getCategory() != RawTypeCategory.UNKNOWN) {
            for (Entry typeEntry : this.typeEntries) {
                if (!typeEntry.getDescriptor().getCategory().equals((Object)in.getCategory())) continue;
                return typeEntry.getDescriptor();
            }
        }
        return SimpleRawTypeDescriptor.UNKNOWN;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Entry {
        private final RawTypeDescriptor descriptor;
        private final Map<TypeParameterKey<?>, Necessity> typeParameterSpecs;

        public Entry(RawTypeDescriptor descriptor) {
            this(descriptor, new HashMap());
        }

        public Entry(RawTypeDescriptor descriptor, Map<TypeParameterKey<?>, Necessity> typeParameterSpecs) {
            Validate.notNull((Object)descriptor);
            Validate.notNull(typeParameterSpecs);
            this.descriptor = descriptor;
            this.typeParameterSpecs = Maps.newHashMap(typeParameterSpecs);
        }

        public RawTypeDescriptor getDescriptor() {
            return this.descriptor;
        }

        public Map<TypeParameterKey<?>, Necessity> getTypeParameterSpecs() {
            return Maps.newHashMap(this.typeParameterSpecs);
        }
    }
}

