/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.dddbase;

import java.util.UUID;
import org.apache.commons.lang.Validate;
import org.jiemamy.dddbase.Entity;
import org.jiemamy.dddbase.EntityNotFoundException;
import org.jiemamy.dddbase.EntityRef;
import org.jiemamy.dddbase.EntityResolver;
import org.jiemamy.dddbase.RepositoryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeEntityResolver
implements EntityResolver {
    private final EntityResolver[] resolvers;

    public CompositeEntityResolver(EntityResolver ... resolvers) {
        Validate.noNullElements((Object[])resolvers);
        this.resolvers = resolvers;
    }

    @Override
    public boolean contains(EntityRef<?> ref) throws RepositoryException {
        for (EntityResolver resolver : this.resolvers) {
            if (!resolver.contains(ref)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(UUID id) throws RepositoryException {
        for (EntityResolver resolver : this.resolvers) {
            if (!resolver.contains(id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <E extends Entity> E resolve(EntityRef<E> ref) throws RepositoryException {
        for (EntityResolver resolver : this.resolvers) {
            try {
                return resolver.resolve(ref);
            }
            catch (EntityNotFoundException e) {
            }
        }
        throw new EntityNotFoundException("id=" + ref.getReferentId());
    }

    @Override
    public Entity resolve(UUID id) throws RepositoryException {
        for (EntityResolver resolver : this.resolvers) {
            try {
                return resolver.resolve(id);
            }
            catch (EntityNotFoundException e) {
            }
        }
        throw new EntityNotFoundException("id=" + id);
    }
}

