/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.buri.common.util;

import java.util.HashMap;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlException;
import org.seasar.buri.exception.BuriException;
import org.seasar.buri.exception.BuriOGNLRuntimeException;
import org.seasar.framework.log.Logger;

public class ScriptProcessor {
    private static Logger logger = Logger.getLogger((Class)ScriptProcessor.class);
    private Map context = Ognl.createDefaultContext(null);
    private static HashMap expressionCache = new HashMap();

    public Object getContext(String name) {
        return this.context.get(name);
    }

    public Map getContext() {
        return this.context;
    }

    public void removeContext(String contextName) {
        this.context.remove(contextName);
    }

    public void putInContext(String name, Object value) {
        this.context.put(name, value);
    }

    public void putAllContext(Map context) {
        if (context == null) {
            return;
        }
        this.context.putAll(context);
    }

    public Object parseExpression(String expression) {
        Object ret = null;
        try {
            ret = Ognl.parseExpression((String)expression);
        }
        catch (OgnlException e) {
            this.processException(e, "EBRI0001", new Object[]{expression, e}, expression, null, null);
        }
        return ret;
    }

    public Object getValueExpression(Object expression, Object root, Map context) {
        Object ret = null;
        try {
            ret = Ognl.getValue((Object)expression, (Map)context, (Object)root);
        }
        catch (OgnlException t) {
            this.processException(t, "EBRI0002", new Object[]{expression, root, t, context}, expression, root, context);
        }
        catch (Exception re) {
            if (re instanceof BuriException) {
                throw (BuriException)re;
            }
            new BuriOGNLRuntimeException("EBRI0002", new Object[]{expression, root, re, context}, re);
        }
        return ret;
    }

    public Object getValueExpression(Object expression, Object root) {
        return this.getValueExpression(expression, root, this.context);
    }

    public Object getValue(String expression, Object root, Map context) {
        Object expresObj = this.getExpression(expression);
        return this.getValueExpression(expresObj, root, context);
    }

    public Object getValue(String expression, Object root) {
        Object expresObj = this.getExpression(expression);
        return this.getValueExpression(expresObj, root);
    }

    public void setValueExpression(Object expression, Object root, Object value, Map context) {
        try {
            Map ognlContext = Ognl.createDefaultContext(null);
            ognlContext.putAll(context);
            Ognl.setValue((Object)expression, (Map)ognlContext, (Object)root, (Object)value);
            context.putAll(ognlContext);
        }
        catch (OgnlException t) {
            this.processException(t, "EBRI0003", new Object[]{expression, root, value, t}, expression, root, context);
        }
        catch (RuntimeException re) {
            if (re instanceof BuriException) {
                throw re;
            }
            new BuriOGNLRuntimeException("EBRI0003", new Object[]{expression, root, value, re, context}, re);
        }
    }

    public void setValueExpression(Object expression, Object root, Object value) {
        this.setValueExpression(expression, root, value, this.context);
    }

    public void setValue(String expression, Object root, Object value, Map context) {
        Object expresObj = this.getExpression(expression);
        this.setValueExpression(expresObj, root, value, context);
    }

    public void setValue(String expression, Object root, Object value) {
        Object expresObj = this.getExpression(expression);
        this.setValueExpression(expresObj, root, value);
    }

    protected synchronized Object getExpression(String expression) {
        Object expresObj = expressionCache.get(expression);
        if (expresObj == null) {
            expresObj = this.parseExpression(expression);
            expressionCache.put(expression, expresObj);
        }
        return expresObj;
    }

    protected void processException(OgnlException e, String message, Object[] objs, Object expression, Object root, Map context) {
        String errInfo = (e.getReason() != null ? "exception=" + e.getReason().toString() : "") + "\nexpression=" + expression + "\ncontext=" + context;
        logger.error((Object)errInfo);
        if (e.getReason() instanceof RuntimeException) {
            throw (RuntimeException)e.getReason();
        }
        throw new BuriOGNLRuntimeException(message, objs, e);
    }
}

