/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.xml;

import java.util.Arrays;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import org.apache.commons.lang.Validate;
import org.jiemamy.xml.JiemamyNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiemamyNamespaceContext
implements NamespaceContext {
    private JiemamyNamespace[] namespaces;

    public JiemamyNamespaceContext(JiemamyNamespace[] namespaces) {
        Validate.notEmpty((Object[])namespaces);
        this.namespaces = (JiemamyNamespace[])namespaces.clone();
    }

    @Override
    public String getNamespaceURI(String prefix) {
        Validate.notNull((Object)prefix);
        for (JiemamyNamespace ns : this.namespaces) {
            if (!prefix.equals(ns.getPrefix())) continue;
            return ns.getNamespaceURI().toString();
        }
        return null;
    }

    @Override
    public String getPrefix(String namespaceURI) {
        Validate.notNull((Object)namespaceURI);
        for (JiemamyNamespace ns : this.namespaces) {
            if (!namespaceURI.equals(ns.getNamespaceURI().toString())) continue;
            return ns.getPrefix();
        }
        return null;
    }

    public Iterator<?> getPrefixes(String namespaceURI) {
        Validate.notNull((Object)namespaceURI);
        String p = this.getPrefix(namespaceURI);
        if (p != null) {
            return Arrays.asList(p).iterator();
        }
        return null;
    }
}

