/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.model.constraint;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.Validate;
import org.jiemamy.JiemamyContext;
import org.jiemamy.dddbase.DefaultEntityRef;
import org.jiemamy.dddbase.Entity;
import org.jiemamy.dddbase.EntityRef;
import org.jiemamy.dddbase.utils.CloneUtil;
import org.jiemamy.dddbase.utils.MutationMonitor;
import org.jiemamy.model.DbObject;
import org.jiemamy.model.ModelConsistencyException;
import org.jiemamy.model.column.JmColumn;
import org.jiemamy.model.constraint.JmForeignKeyConstraint;
import org.jiemamy.model.constraint.JmKeyConstraint;
import org.jiemamy.model.constraint.SimpleJmKeyConstraint;
import org.jiemamy.model.table.JmTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleJmForeignKeyConstraint
extends SimpleJmKeyConstraint
implements JmForeignKeyConstraint {
    private List<EntityRef<? extends JmColumn>> referenceColumns = Lists.newArrayList();
    private JmForeignKeyConstraint.ReferentialAction onDelete;
    private JmForeignKeyConstraint.ReferentialAction onUpdate;
    private JmForeignKeyConstraint.MatchType matchType;

    public static JmForeignKeyConstraint of(JmColumn keyColumn, JmColumn referenceColumn) {
        Validate.notNull((Object)keyColumn);
        Validate.notNull((Object)referenceColumn);
        SimpleJmForeignKeyConstraint fk = new SimpleJmForeignKeyConstraint();
        fk.addReferencing(keyColumn.toReference(), referenceColumn.toReference());
        return fk;
    }

    public SimpleJmForeignKeyConstraint() {
        this(UUID.randomUUID());
    }

    public SimpleJmForeignKeyConstraint(UUID id) {
        super(id);
    }

    @Override
    public void addKeyColumn(EntityRef<? extends JmColumn> keyColumn) {
        Validate.notNull(keyColumn);
        super.addKeyColumn(keyColumn);
    }

    public void addReferenceColumn(EntityRef<? extends JmColumn> referenceColumn) {
        Validate.notNull(referenceColumn);
        this.referenceColumns.add(referenceColumn);
    }

    public void addReferencing(EntityRef<? extends JmColumn> keyColumn, EntityRef<? extends JmColumn> referenceColumn) {
        Validate.notNull(keyColumn);
        Validate.notNull(referenceColumn);
        this.addKeyColumn(keyColumn);
        this.addReferenceColumn(referenceColumn);
    }

    @Override
    public void clearKeyColumns() {
        super.clearKeyColumns();
        this.referenceColumns.clear();
    }

    @Override
    public SimpleJmForeignKeyConstraint clone() {
        SimpleJmForeignKeyConstraint clone = (SimpleJmForeignKeyConstraint)super.clone();
        clone.referenceColumns = CloneUtil.cloneValueArrayList(this.referenceColumns);
        return clone;
    }

    @Override
    public JmKeyConstraint findReferencedKeyConstraint(Iterable<? extends DbObject> dbObjects) {
        Validate.notNull(dbObjects);
        List<EntityRef<? extends JmColumn>> referenceColumns = this.getReferenceColumns();
        if (referenceColumns.size() == 0) {
            throw new ModelConsistencyException();
        }
        EntityRef<? extends JmColumn> columnRef = referenceColumns.get(0);
        for (DbObject dbObject : dbObjects) {
            Validate.notNull((Object)dbObject);
            for (Entity subEntity : dbObject.getSubEntities()) {
                if (!columnRef.isReferenceOf(subEntity)) continue;
                JmTable table = (JmTable)dbObject;
                return table.findReferencedKeyConstraint(this);
            }
        }
        return null;
    }

    @Override
    public JmTable findReferenceTable(Iterable<JmTable> tables) {
        Validate.notNull(tables);
        JmKeyConstraint keyConstraint = this.findReferencedKeyConstraint(tables);
        if (keyConstraint != null) {
            return keyConstraint.findDeclaringTable(tables);
        }
        return null;
    }

    @Override
    public JmForeignKeyConstraint.MatchType getMatchType() {
        return this.matchType;
    }

    @Override
    public JmForeignKeyConstraint.ReferentialAction getOnDelete() {
        return this.onDelete;
    }

    @Override
    public JmForeignKeyConstraint.ReferentialAction getOnUpdate() {
        return this.onUpdate;
    }

    @Override
    public List<EntityRef<? extends JmColumn>> getReferenceColumns() {
        return MutationMonitor.monitor((List)Lists.newArrayList(this.referenceColumns));
    }

    @Override
    public boolean isSelfReference(JiemamyContext context) {
        Validate.notNull((Object)context);
        Set<JmTable> tables = context.getTables();
        JmTable declaringTableOfForeignKey = this.findDeclaringTable(tables);
        JmKeyConstraint referencedKeyConstraint = this.findReferencedKeyConstraint(tables);
        JmTable declaringTableOfReferenceKey = referencedKeyConstraint.findDeclaringTable(tables);
        return declaringTableOfForeignKey.equals(declaringTableOfReferenceKey);
    }

    public void setMatchType(JmForeignKeyConstraint.MatchType matchType) {
        this.matchType = matchType;
    }

    public void setOnDelete(JmForeignKeyConstraint.ReferentialAction onDelete) {
        this.onDelete = onDelete;
    }

    public void setOnUpdate(JmForeignKeyConstraint.ReferentialAction onUpdate) {
        this.onUpdate = onUpdate;
    }

    public EntityRef<? extends SimpleJmForeignKeyConstraint> toReference() {
        return new DefaultEntityRef((Entity)this);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.insert(sb.length() - 1, "->" + this.referenceColumns);
        return sb.toString();
    }
}

