/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.helper.DefaultArchiveRemover;
import ch.qos.logback.core.rolling.helper.FileFilterUtil;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.rolling.helper.RollingCalendar;
import java.io.File;
import java.util.Date;

public class SizeAndTimeBasedArchiveRemover
extends DefaultArchiveRemover {
    public SizeAndTimeBasedArchiveRemover(FileNamePattern fileNamePattern, RollingCalendar rc) {
        super(fileNamePattern, rc);
    }

    public void clean(Date now) {
        File[] matchingFileArray;
        Date dateOfPeriodToClean = this.rc.getRelativeDate(now, this.periodOffsetForDeletionTarget);
        String regex = this.fileNamePattern.toRegex(dateOfPeriodToClean);
        String stemRegex = FileFilterUtil.afterLastSlash(regex);
        File archive0 = new File(this.fileNamePattern.convertMultipleArguments(dateOfPeriodToClean, 0));
        File parentDir = archive0.getParentFile();
        for (File f : matchingFileArray = FileFilterUtil.filesInFolderMatchingStemRegex(parentDir, stemRegex)) {
            f.delete();
        }
        if (this.parentClean) {
            this.removeFolderIfEmpty(parentDir, 0);
        }
    }
}

