/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.annotation.tiger.impl;

import java.lang.annotation.Annotation;
import org.seasar.dao.Dbms;
import org.seasar.dao.annotation.tiger.Bean;
import org.seasar.dao.annotation.tiger.Column;
import org.seasar.dao.annotation.tiger.Id;
import org.seasar.dao.annotation.tiger.IdType;
import org.seasar.dao.annotation.tiger.Ids;
import org.seasar.dao.annotation.tiger.Relation;
import org.seasar.dao.annotation.tiger.ValueType;
import org.seasar.dao.impl.FieldBeanAnnotationReader;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanAnnotationReaderImpl
extends FieldBeanAnnotationReader {
    private Class<?> beanClass_;
    private Bean bean_;

    public BeanAnnotationReaderImpl(Class beanClass) {
        super(beanClass);
        this.beanClass_ = beanClass;
        this.bean_ = this.beanClass_.getAnnotation(Bean.class);
    }

    private <T extends Annotation> T getPropertyAnnotation(Class<T> clazz, PropertyDesc pd) {
        T annotation;
        T fieldAnnotation;
        BeanDesc bd = BeanDescFactory.getBeanDesc(this.beanClass_);
        if (bd.hasField(pd.getPropertyName()) && (fieldAnnotation = bd.getField(pd.getPropertyName()).getAnnotation(clazz)) != null) {
            return fieldAnnotation;
        }
        if (pd.getWriteMethod() != null && (annotation = pd.getWriteMethod().getAnnotation(clazz)) != null) {
            return annotation;
        }
        if (pd.getReadMethod() != null) {
            return pd.getReadMethod().getAnnotation(clazz);
        }
        return null;
    }

    public String getColumnAnnotation(PropertyDesc pd) {
        Column column = this.getPropertyAnnotation(Column.class, pd);
        return column != null ? column.value() : super.getColumnAnnotation(pd);
    }

    public String getTableAnnotation() {
        if (this.bean_ == null || this.bean_.table().length() == 0) {
            return super.getTableAnnotation();
        }
        return this.bean_.table();
    }

    public String getVersionNoPropertyName() {
        return this.bean_ != null ? this.bean_.versionNoProperty() : super.getVersionNoPropertyName();
    }

    public String getTimestampPropertyName() {
        return this.bean_ != null ? this.bean_.timeStampProperty() : super.getTimestampPropertyName();
    }

    public String getId(PropertyDesc pd, Dbms dbms) {
        String dbmsSuffix = dbms.getSuffix();
        Id id = this.getIds(pd, dbmsSuffix);
        if (id == null) {
            id = this.getPropertyAnnotation(Id.class, pd);
            if (id == null) {
                return super.getId(pd, dbms);
            }
            if (("_" + id.dbms()).equals(dbms.getSuffix()) || id.dbms().equals("")) {
                return this.getIdName(id);
            }
            return null;
        }
        return this.getIdName(id);
    }

    public String[] getNoPersisteneProps() {
        return this.bean_ != null ? this.bean_.noPersistentProperty() : super.getNoPersisteneProps();
    }

    public boolean hasRelationNo(PropertyDesc pd) {
        Relation rel = this.getPropertyAnnotation(Relation.class, pd);
        return rel != null ? rel != null : super.hasRelationNo(pd);
    }

    public int getRelationNo(PropertyDesc pd) {
        Relation rel = this.getPropertyAnnotation(Relation.class, pd);
        return rel != null ? rel.relationNo() : super.getRelationNo(pd);
    }

    public String getRelationKey(PropertyDesc pd) {
        Relation rel = this.getPropertyAnnotation(Relation.class, pd);
        return rel != null ? rel.relationKey() : super.getRelationKey(pd);
    }

    public String getValueType(PropertyDesc pd) {
        ValueType valueType = this.getPropertyAnnotation(ValueType.class, pd);
        return valueType != null ? valueType.value() : super.getValueType(pd);
    }

    protected Id getIds(PropertyDesc pd, String dbmsSuffix) {
        Ids ids = this.getPropertyAnnotation(Ids.class, pd);
        if (ids == null || ids.value().length == 0) {
            return null;
        }
        Id defaultId = null;
        for (int i = 0; i < ids.value().length; ++i) {
            Id id = ids.value()[i];
            if (dbmsSuffix.equals("_" + id.dbms())) {
                return id;
            }
            if (!"".equals(id.dbms())) continue;
            defaultId = id;
        }
        return defaultId;
    }

    protected String getIdName(Id id) {
        if (id.value().equals((Object)IdType.SEQUENCE) && id.sequenceName() != null) {
            StringBuilder buf = new StringBuilder(100);
            buf.append(id.value().name().toLowerCase());
            buf.append(", sequenceName=");
            buf.append(id.sequenceName());
            buf.append(", allocationSize=");
            buf.append(id.allocationSize());
            return buf.toString();
        }
        return id.value().name().toLowerCase();
    }
}

