/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils.sql.metadata;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.Validate;
import org.jiemamy.utils.sql.metadata.AttributesMeta;
import org.jiemamy.utils.sql.metadata.BestRowIdentifierMeta;
import org.jiemamy.utils.sql.metadata.CatalogMeta;
import org.jiemamy.utils.sql.metadata.ColumnMeta;
import org.jiemamy.utils.sql.metadata.ColumnPrivilegeMeta;
import org.jiemamy.utils.sql.metadata.IndexInfoMeta;
import org.jiemamy.utils.sql.metadata.KeyMeta;
import org.jiemamy.utils.sql.metadata.PrimaryKeyMeta;
import org.jiemamy.utils.sql.metadata.ProcedureColumnsMeta;
import org.jiemamy.utils.sql.metadata.ProcedureMeta;
import org.jiemamy.utils.sql.metadata.SchemaMeta;
import org.jiemamy.utils.sql.metadata.SuperTableMeta;
import org.jiemamy.utils.sql.metadata.SuperTypeMeta;
import org.jiemamy.utils.sql.metadata.TableMeta;
import org.jiemamy.utils.sql.metadata.TablePrivilegeMeta;
import org.jiemamy.utils.sql.metadata.TableTypeMeta;
import org.jiemamy.utils.sql.metadata.TypeInfoMeta;
import org.jiemamy.utils.sql.metadata.TypeSafeResultSet;
import org.jiemamy.utils.sql.metadata.UDTMeta;
import org.jiemamy.utils.sql.metadata.VersionColumnMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSafeDatabaseMetaData {
    private final DatabaseMetaData metaData;

    public TypeSafeDatabaseMetaData(Connection connection) throws SQLException {
        Validate.notNull((Object)connection);
        this.metaData = connection.getMetaData();
    }

    public TypeSafeDatabaseMetaData(DatabaseMetaData metaData) {
        Validate.notNull((Object)metaData);
        this.metaData = metaData;
    }

    public TypeSafeResultSet<AttributesMeta> getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        ResultSet attributes = this.metaData.getAttributes(catalog, schemaPattern, typeNamePattern, attributeNamePattern);
        return new TypeSafeResultSet<AttributesMeta>(attributes, AttributesMeta.class);
    }

    public TypeSafeResultSet<BestRowIdentifierMeta> getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        ResultSet bestRowIdentifier = this.metaData.getBestRowIdentifier(catalog, schema, table, scope, nullable);
        return new TypeSafeResultSet<BestRowIdentifierMeta>(bestRowIdentifier, BestRowIdentifierMeta.class);
    }

    public TypeSafeResultSet<CatalogMeta> getCatalogs() throws SQLException {
        ResultSet catalogs = this.metaData.getCatalogs();
        return new TypeSafeResultSet<CatalogMeta>(catalogs, CatalogMeta.class);
    }

    public TypeSafeResultSet<ColumnPrivilegeMeta> getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        ResultSet columnPrivileges = this.metaData.getColumnPrivileges(catalog, schema, table, columnNamePattern);
        return new TypeSafeResultSet<ColumnPrivilegeMeta>(columnPrivileges, ColumnPrivilegeMeta.class);
    }

    public TypeSafeResultSet<ColumnMeta> getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        ResultSet tables = this.metaData.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
        return new TypeSafeResultSet<ColumnMeta>(tables, ColumnMeta.class);
    }

    public TypeSafeResultSet<KeyMeta> getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        ResultSet crossReference = this.metaData.getCrossReference(primaryCatalog, primarySchema, primaryTable, foreignCatalog, foreignSchema, foreignTable);
        return new TypeSafeResultSet<KeyMeta>(crossReference, KeyMeta.class);
    }

    public TypeSafeResultSet<KeyMeta> getExportedKeys(String catalog, String schema, String table) throws SQLException {
        ResultSet exportedKeys = this.metaData.getExportedKeys(catalog, schema, table);
        return new TypeSafeResultSet<KeyMeta>(exportedKeys, KeyMeta.class);
    }

    public TypeSafeResultSet<KeyMeta> getImportedKeys(String catalog, String schema, String table) throws SQLException {
        ResultSet importedKeys = this.metaData.getImportedKeys(catalog, schema, table);
        return new TypeSafeResultSet<KeyMeta>(importedKeys, KeyMeta.class);
    }

    public TypeSafeResultSet<IndexInfoMeta> getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        ResultSet indexInfo = this.metaData.getIndexInfo(catalog, schema, table, unique, approximate);
        return new TypeSafeResultSet<IndexInfoMeta>(indexInfo, IndexInfoMeta.class);
    }

    public DatabaseMetaData getMetaData() {
        return this.metaData;
    }

    public TypeSafeResultSet<PrimaryKeyMeta> getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        ResultSet primaryKeys = this.metaData.getPrimaryKeys(catalog, schema, table);
        return new TypeSafeResultSet<PrimaryKeyMeta>(primaryKeys, PrimaryKeyMeta.class);
    }

    public TypeSafeResultSet<ProcedureColumnsMeta> getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        ResultSet procedureColumns = this.metaData.getProcedureColumns(catalog, schemaPattern, procedureNamePattern, columnNamePattern);
        return new TypeSafeResultSet<ProcedureColumnsMeta>(procedureColumns, ProcedureColumnsMeta.class);
    }

    public TypeSafeResultSet<ProcedureMeta> getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        ResultSet procedures = this.metaData.getProcedures(catalog, schemaPattern, procedureNamePattern);
        return new TypeSafeResultSet<ProcedureMeta>(procedures, ProcedureMeta.class);
    }

    public TypeSafeResultSet<SchemaMeta> getSchemas() throws SQLException {
        ResultSet schemas = this.metaData.getSchemas();
        return new TypeSafeResultSet<SchemaMeta>(schemas, SchemaMeta.class);
    }

    public TypeSafeResultSet<SuperTableMeta> getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        ResultSet superTables = this.metaData.getSuperTables(catalog, schemaPattern, tableNamePattern);
        return new TypeSafeResultSet<SuperTableMeta>(superTables, SuperTableMeta.class);
    }

    public TypeSafeResultSet<SuperTypeMeta> getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        ResultSet superTypes = this.metaData.getSuperTypes(catalog, schemaPattern, typeNamePattern);
        return new TypeSafeResultSet<SuperTypeMeta>(superTypes, SuperTypeMeta.class);
    }

    public TypeSafeResultSet<TablePrivilegeMeta> getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        ResultSet tablePrivileges = this.metaData.getTablePrivileges(catalog, schemaPattern, tableNamePattern);
        return new TypeSafeResultSet<TablePrivilegeMeta>(tablePrivileges, TablePrivilegeMeta.class);
    }

    public TypeSafeResultSet<TableMeta> getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        ResultSet tables = this.metaData.getTables(catalog, schemaPattern, tableNamePattern, types);
        return new TypeSafeResultSet<TableMeta>(tables, TableMeta.class);
    }

    public TypeSafeResultSet<TableTypeMeta> getTableTypes() throws SQLException {
        ResultSet tableTypes = this.metaData.getTableTypes();
        return new TypeSafeResultSet<TableTypeMeta>(tableTypes, TableTypeMeta.class);
    }

    public TypeSafeResultSet<TypeInfoMeta> getTypeInfo() throws SQLException {
        ResultSet typeInfo = this.metaData.getTypeInfo();
        return new TypeSafeResultSet<TypeInfoMeta>(typeInfo, TypeInfoMeta.class);
    }

    public TypeSafeResultSet<UDTMeta> getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        ResultSet udts = this.metaData.getUDTs(catalog, schemaPattern, typeNamePattern, types);
        return new TypeSafeResultSet<UDTMeta>(udts, UDTMeta.class);
    }

    public TypeSafeResultSet<VersionColumnMeta> getVersionColumns(String catalog, String schema, String table) throws SQLException {
        ResultSet versionColumns = this.metaData.getVersionColumns(catalog, schema, table);
        return new TypeSafeResultSet<VersionColumnMeta>(versionColumns, VersionColumnMeta.class);
    }
}

