/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.dddbase.utils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MutationMonitor {
    private static Logger logger = LoggerFactory.getLogger(MutationMonitor.class);
    private static boolean debug;

    public static boolean isDebug() {
        return debug;
    }

    public static <E> List<E> monitor(List<E> core) {
        if (MutationMonitor.isDebug()) {
            return MutationMonitor.wrap(core, List.class);
        }
        return core;
    }

    public static <K, V> Map<K, V> monitor(Map<K, V> core) {
        if (MutationMonitor.isDebug()) {
            return MutationMonitor.wrap(core);
        }
        return core;
    }

    public static <E> Set<E> monitor(Set<E> core) {
        if (MutationMonitor.isDebug()) {
            return MutationMonitor.wrap(core, Set.class);
        }
        return core;
    }

    public static <E> SortedSet<E> monitor(SortedSet<E> core) {
        if (MutationMonitor.isDebug()) {
            return MutationMonitor.wrap(core, SortedSet.class);
        }
        return core;
    }

    public static void setDebug(boolean debug) {
        MutationMonitor.debug = debug;
    }

    static <C extends Collection<E>, E> C wrap(final C core, Class<C> clazz) {
        return (C)((Collection)clazz.cast(Proxy.newProxyInstance(null, new Class[]{clazz}, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (Arrays.asList("add", "addAll", "remove", "removeAll", "retainAll", "clear").contains(method.getName())) {
                    logger.warn("{} on {}", (Object)method.toString(), (Object)core.toString());
                    logger.trace("stack trace: ", (Throwable)new Exception());
                }
                return method.invoke((Object)core, args);
            }
        })));
    }

    static <K, V> Map<K, V> wrap(final Map<K, V> core) {
        return (Map)Proxy.newProxyInstance(null, new Class[]{Map.class}, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (Arrays.asList("put", "putAll", "remove", "clear").contains(method.getName())) {
                    logger.warn("{} on {}", (Object)method.toString(), (Object)core.toString());
                    logger.trace("stack trace: ", (Throwable)new Exception());
                }
                return method.invoke((Object)core, args);
            }
        });
    }

    private MutationMonitor() {
    }
}

