/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.pager;

import javax.servlet.http.HttpServletRequest;
import org.seasar.dao.pager.PagerCondition;
import org.seasar.framework.util.ClassUtil;

public class PagerSupport {
    public static final int DEFAULT_LIMIT = -1;
    private int limit = -1;
    private Class pagerConditionClass;
    private String pagerConditionName;

    public PagerSupport(Class pagerConditionClass, String pagerConditionName) {
        this(-1, pagerConditionClass, pagerConditionName);
    }

    public PagerSupport(int limit, Class pagerConditionClass, String pagerConditionName) {
        this.limit = limit;
        this.pagerConditionClass = pagerConditionClass;
        this.pagerConditionName = pagerConditionName;
    }

    public void updateOffset(HttpServletRequest request, String offsetParamName) {
        int offset = this.getOffset(request, offsetParamName);
        PagerCondition pagerCondition = this.getPagerCondition(request);
        pagerCondition.setOffset(offset);
    }

    public void updateOffset(HttpServletRequest request) {
        this.updateOffset(request, "offset");
    }

    private int getOffset(HttpServletRequest request, String offsetParamName) {
        String value = request.getParameter(offsetParamName);
        if (value == null || value.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public PagerCondition getPagerCondition(HttpServletRequest request) {
        PagerCondition dto = (PagerCondition)request.getSession().getAttribute(this.pagerConditionName);
        if (dto == null) {
            dto = (PagerCondition)ClassUtil.newInstance((Class)this.pagerConditionClass);
            dto.setLimit(this.limit);
            request.getSession().setAttribute(this.pagerConditionName, (Object)dto);
        }
        return dto;
    }
}

