/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.ant;

import java.util.ArrayList;
import java.util.List;

/**
 * 出力種別ごとの出力先を保持するリストです。
 * 
 * @author azusa
 * 
 */
public class DirectoryList {

    private final List<Directory> list = new ArrayList<Directory>();

    /**
     * 出力先を追加します。
     * 
     * @param directory
     *            出力種別
     * @param destination
     *            出力先
     */
    public void add(String directory, String destination) {
        list.add(new Directory(directory, destination));

    }

    /**
     * 出力種別に対する出力先を返します。
     * 
     * @param directoryName
     *            出力種別
     * @return 出力先
     * @throws IllegalArgumentException
     *             出力種別に対する出力先が存在しない場合
     */
    public Directory getDirectory(String directoryName) {
        for (Directory directory : list) {
            if (directoryName.equals(directory.getPath())) {
                return directory;
            }
        }
        throw new IllegalArgumentException(directoryName);

    }
}
