/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.RelationPropertyType;
import org.seasar.dao.RelationRowCreator;
import org.seasar.dao.impl.RelationRowCreationResource;
import org.seasar.dao.util.PropertyDescUtil;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.util.ClassUtil;

public class RelationRowCreatorImpl
implements RelationRowCreator {
    public Object createRelationRow(ResultSet rs, RelationPropertyType rpt, Set columnNames, Map relKeyValues, Map relationPropertyCache) throws SQLException {
        RelationRowCreationResource res = this.createResourceForRow(rs, rpt, columnNames, relKeyValues, relationPropertyCache);
        return this.createRelationRow(res);
    }

    protected RelationRowCreationResource createResourceForRow(ResultSet rs, RelationPropertyType rpt, Set columnNames, Map relKeyValues, Map relationPropertyCache) throws SQLException {
        RelationRowCreationResource res = new RelationRowCreationResource();
        res.setResultSet(rs);
        res.setRelationPropertyType(rpt);
        res.setColumnNames(columnNames);
        res.setRelKeyValues(relKeyValues);
        res.setRelationPropertyCache(relationPropertyCache);
        res.setBaseSuffix("");
        res.setRelationNoSuffix(this.buildRelationNoSuffix(rpt));
        res.setLimitRelationNestLevel(this.getLimitRelationNestLevel());
        res.setCurrentRelationNestLevel(1);
        res.setCreateDeadLink(this.isCreateDeadLink());
        return res;
    }

    protected Object createRelationRow(RelationRowCreationResource res) throws SQLException {
        if (!res.hasPropertyCacheElement()) {
            return null;
        }
        this.setupRelationKeyValue(res);
        this.setupRelationAllValue(res);
        return res.getRow();
    }

    protected void setupRelationKeyValue(RelationRowCreationResource res) {
        RelationPropertyType rpt = res.getRelationPropertyType();
        BeanMetaData bmd = rpt.getBeanMetaData();
        for (int i = 0; i < rpt.getKeySize(); ++i) {
            Object value;
            String columnName = rpt.getMyKey(i) + res.getBaseSuffix();
            if (!res.containsColumnName(columnName)) continue;
            if (!res.hasRowInstance()) {
                res.setRow(this.newRelationRow(rpt));
            }
            if (!res.containsRelKeyValueIfExists(columnName) || (value = res.extractRelKeyValue(columnName)) == null) continue;
            String yourKey = rpt.getYourKey(i);
            PropertyType pt = bmd.getPropertyTypeByColumnName(yourKey);
            PropertyDesc pd = pt.getPropertyDesc();
            pd.setValue(res.getRow(), value);
        }
    }

    protected void setupRelationAllValue(RelationRowCreationResource res) throws SQLException {
        Map propertyCacheElement = res.extractPropertyCacheElement();
        Set columnNameCacheElementKeySet = propertyCacheElement.keySet();
        Iterator ite = columnNameCacheElementKeySet.iterator();
        while (ite.hasNext()) {
            String columnName = (String)ite.next();
            PropertyType pt = (PropertyType)propertyCacheElement.get(columnName);
            res.setCurrentPropertyType(pt);
            if (!this.isValidRelationPerPropertyLoop(res)) {
                res.clearRowInstance();
                return;
            }
            this.setupRelationProperty(res);
        }
        if (!this.isValidRelationAfterPropertyLoop(res)) {
            res.clearRowInstance();
            return;
        }
        res.clearValidValueCount();
        if (res.hasNextRelationProperty() && res.hasNextRelationLevel()) {
            this.setupNextRelationRow(res);
        }
    }

    protected boolean isValidRelationPerPropertyLoop(RelationRowCreationResource res) throws SQLException {
        return true;
    }

    protected boolean isValidRelationAfterPropertyLoop(RelationRowCreationResource res) throws SQLException {
        if (res.isCreateDeadLink()) {
            return true;
        }
        return res.hasValidValueCount();
    }

    protected void setupRelationProperty(RelationRowCreationResource res) throws SQLException {
        String columnName = res.buildRelationColumnName();
        if (!res.hasRowInstance()) {
            res.setRow(this.newRelationRow(res));
        }
        this.registerRelationValue(res, columnName);
    }

    protected void registerRelationValue(RelationRowCreationResource res, String columnName) throws SQLException {
        PropertyType pt = res.getCurrentPropertyType();
        Object value = null;
        if (res.containsRelKeyValueIfExists(columnName)) {
            value = res.extractRelKeyValue(columnName);
        } else {
            ValueType valueType = pt.getValueType();
            value = valueType.getValue(res.getResultSet(), columnName);
        }
        if (value != null) {
            this.registerRelationValidValue(res, pt, value);
        }
    }

    protected void registerRelationValidValue(RelationRowCreationResource res, PropertyType pt, Object value) throws SQLException {
        res.incrementValidValueCount();
        PropertyDesc pd = pt.getPropertyDesc();
        pd.setValue(res.getRow(), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupNextRelationRow(RelationRowCreationResource res) throws SQLException {
        BeanMetaData nextBmd = res.getRelationBeanMetaData();
        Object row = res.getRow();
        res.backupRelationPropertyType();
        res.incrementCurrentRelationNestLevel();
        try {
            for (int i = 0; i < nextBmd.getRelationPropertyTypeSize(); ++i) {
                RelationPropertyType nextRpt = nextBmd.getRelationPropertyType(i);
                this.setupNextRelationRowElement(res, row, nextRpt);
            }
        }
        finally {
            res.setRow(row);
            res.restoreRelationPropertyType();
            res.decrementCurrentRelationNestLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupNextRelationRowElement(RelationRowCreationResource res, Object row, RelationPropertyType nextRpt) throws SQLException {
        if (nextRpt == null) {
            return;
        }
        res.clearRowInstance();
        res.setRelationPropertyType(nextRpt);
        String baseSuffix = res.getRelationNoSuffix();
        String additionalRelationNoSuffix = this.buildRelationNoSuffix(nextRpt);
        res.backupSuffixAndPrepare(baseSuffix, additionalRelationNoSuffix);
        try {
            Object relationRow = this.createRelationRow(res);
            if (relationRow != null) {
                nextRpt.getPropertyDesc().setValue(row, relationRow);
            }
        }
        finally {
            res.restoreSuffix();
        }
    }

    public Map createPropertyCache(Set columnNames, BeanMetaData bmd) throws SQLException {
        Map relationPropertyCache = this.newRelationPropertyCache();
        for (int i = 0; i < bmd.getRelationPropertyTypeSize(); ++i) {
            RelationPropertyType rpt = bmd.getRelationPropertyType(i);
            String baseSuffix = "";
            String relationNoSuffix = this.buildRelationNoSuffix(rpt);
            RelationRowCreationResource res = this.createResourceForPropertyCache(rpt, columnNames, relationPropertyCache, "", relationNoSuffix, this.getLimitRelationNestLevel());
            if (rpt == null) continue;
            this.setupPropertyCache(res);
        }
        return relationPropertyCache;
    }

    protected RelationRowCreationResource createResourceForPropertyCache(RelationPropertyType rpt, Set columnNames, Map relationPropertyCache, String baseSuffix, String relationNoSuffix, int limitRelationNestLevel) throws SQLException {
        RelationRowCreationResource res = new RelationRowCreationResource();
        res.setRelationPropertyType(rpt);
        res.setColumnNames(columnNames);
        res.setRelationPropertyCache(relationPropertyCache);
        res.setBaseSuffix(baseSuffix);
        res.setRelationNoSuffix(relationNoSuffix);
        res.setLimitRelationNestLevel(limitRelationNestLevel);
        res.setCurrentRelationNestLevel(1);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupPropertyCache(RelationRowCreationResource res) throws SQLException {
        res.initializePropertyCacheElement();
        if (!this.isTargetRelation(res)) {
            return;
        }
        BeanMetaData nextBmd = res.getRelationBeanMetaData();
        for (int i = 0; i < nextBmd.getPropertyTypeSize(); ++i) {
            PropertyType pt = nextBmd.getPropertyType(i);
            res.setCurrentPropertyType(pt);
            if (!this.isTargetProperty(res)) continue;
            this.setupPropertyCacheElement(res);
        }
        if (res.hasNextRelationProperty() && res.hasNextRelationLevel()) {
            res.backupRelationPropertyType();
            res.incrementCurrentRelationNestLevel();
            try {
                this.setupNextPropertyCache(res, nextBmd);
            }
            finally {
                res.restoreRelationPropertyType();
                res.decrementCurrentRelationNestLevel();
            }
        }
    }

    protected void setupPropertyCacheElement(RelationRowCreationResource res) throws SQLException {
        String columnName = res.buildRelationColumnName();
        if (!res.containsColumnName(columnName)) {
            return;
        }
        res.savePropertyCacheElement();
    }

    protected void setupNextPropertyCache(RelationRowCreationResource res, BeanMetaData nextBmd) throws SQLException {
        for (int i = 0; i < nextBmd.getRelationPropertyTypeSize(); ++i) {
            RelationPropertyType nextNextRpt = nextBmd.getRelationPropertyType(i);
            res.setRelationPropertyType(nextNextRpt);
            this.setupNextPropertyCacheElement(res, nextNextRpt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupNextPropertyCacheElement(RelationRowCreationResource res, RelationPropertyType nextNextRpt) throws SQLException {
        String baseSuffix = res.getRelationNoSuffix();
        String additionalRelationNoSuffix = this.buildRelationNoSuffix(nextNextRpt);
        res.backupSuffixAndPrepare(baseSuffix, additionalRelationNoSuffix);
        try {
            this.setupPropertyCache(res);
        }
        finally {
            res.restoreSuffix();
        }
    }

    protected Map newRelationPropertyCache() {
        return new HashMap();
    }

    protected String buildRelationNoSuffix(RelationPropertyType rpt) {
        return "_" + rpt.getRelationNo();
    }

    protected Object newRelationRow(RelationRowCreationResource res) {
        return this.newRelationRow(res.getRelationPropertyType());
    }

    protected Object newRelationRow(RelationPropertyType rpt) {
        return ClassUtil.newInstance((Class)rpt.getPropertyDesc().getPropertyType());
    }

    protected boolean isTargetRelation(RelationRowCreationResource res) throws SQLException {
        return true;
    }

    protected boolean isTargetProperty(RelationRowCreationResource res) throws SQLException {
        PropertyType pt = res.getCurrentPropertyType();
        return PropertyDescUtil.isWritable(pt.getPropertyDesc());
    }

    protected boolean isCreateDeadLink() {
        return true;
    }

    protected int getLimitRelationNestLevel() {
        return 1;
    }
}

