/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.id;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.seasar.dao.Dbms;
import org.seasar.dao.IdentifierGenerator;
import org.seasar.dao.id.AssignedIdentifierGenerator;
import org.seasar.dao.id.IdentityIdentifierGenerator;
import org.seasar.dao.id.SequenceIdentifierGenerator;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.ConstructorUtil;
import org.seasar.framework.util.StringUtil;

public class IdentifierGeneratorFactory {
    private static Map generatorClasses = new HashMap();

    private IdentifierGeneratorFactory() {
    }

    public static void addIdentifierGeneratorClass(String name, Class clazz) {
        generatorClasses.put(name, clazz);
    }

    public static IdentifierGenerator createIdentifierGenerator(PropertyType propertyType, Dbms dbms) {
        return IdentifierGeneratorFactory.createIdentifierGenerator(propertyType, dbms, null);
    }

    public static IdentifierGenerator createIdentifierGenerator(PropertyType propertyType, Dbms dbms, String annotation) {
        if (propertyType == null) {
            throw new EmptyRuntimeException("propertyType");
        }
        if (dbms == null) {
            throw new EmptyRuntimeException("dbms");
        }
        if (annotation == null) {
            return new AssignedIdentifierGenerator(propertyType, dbms);
        }
        String[] array = StringUtil.split((String)annotation, (String)"=, ");
        Class clazz = IdentifierGeneratorFactory.getGeneratorClass(array[0]);
        IdentifierGenerator generator = IdentifierGeneratorFactory.createIdentifierGenerator(clazz, propertyType, dbms);
        for (int i = 1; i < array.length; i += 2) {
            IdentifierGeneratorFactory.setProperty(generator, array[i].trim(), array[i + 1].trim());
        }
        return generator;
    }

    protected static Class getGeneratorClass(String name) {
        Class clazz = (Class)generatorClasses.get(name);
        if (clazz != null) {
            return clazz;
        }
        return ClassUtil.forName((String)name);
    }

    protected static IdentifierGenerator createIdentifierGenerator(Class clazz, PropertyType propertyType, Dbms dbms) {
        Constructor constructor = ClassUtil.getConstructor((Class)clazz, (Class[])new Class[]{PropertyType.class, Dbms.class});
        return (IdentifierGenerator)ConstructorUtil.newInstance((Constructor)constructor, (Object[])new Object[]{propertyType, dbms});
    }

    protected static void setProperty(IdentifierGenerator generator, String propertyName, String value) {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(generator.getClass());
        PropertyDesc pd = beanDesc.getPropertyDesc(propertyName);
        pd.setValue((Object)generator, (Object)value);
    }

    static {
        IdentifierGeneratorFactory.addIdentifierGeneratorClass("assigned", AssignedIdentifierGenerator.class);
        IdentifierGeneratorFactory.addIdentifierGeneratorClass("identity", IdentityIdentifierGenerator.class);
        IdentifierGeneratorFactory.addIdentifierGeneratorClass("sequence", SequenceIdentifierGenerator.class);
    }
}

