/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.buri.oouo.reader.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.seasar.buri.oouo.reader.OouoClassDef;
import org.seasar.buri.oouo.reader.OouoClassDefFactory;
import org.seasar.buri.oouo.reader.OouoReader;
import org.seasar.buri.oouo.reader.impl.XmlHandler;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.exception.ParserConfigurationRuntimeException;
import org.seasar.framework.exception.SAXRuntimeException;
import org.seasar.framework.util.FileInputStreamUtil;
import org.seasar.framework.util.ResourceUtil;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLOouoReader
implements OouoReader {
    private Map rootClass = new HashMap();
    private S2Container container;
    private OouoClassDefFactory oouoClassDefFactory;

    public Object readResource(String resourceName) {
        URL resource = ResourceUtil.getResource((String)resourceName);
        try {
            return this.read(resource.openStream());
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public Object readFile(String fileName) {
        File file = new File(fileName);
        FileInputStream is = FileInputStreamUtil.create((File)file);
        return this.read(is);
    }

    protected Object read(InputStream input) {
        XmlHandler xmlHandler = new XmlHandler();
        xmlHandler.setClassDefFactory(this.oouoClassDefFactory);
        xmlHandler.setContainer(this.container);
        SAXParserFactory spfactory = SAXParserFactory.newInstance();
        SAXParser parser = null;
        try {
            parser = spfactory.newSAXParser();
            parser.parse(input, (DefaultHandler)xmlHandler);
        }
        catch (ParserConfigurationException e) {
            throw new ParserConfigurationRuntimeException(e);
        }
        catch (SAXException e) {
            throw new SAXRuntimeException(e);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return xmlHandler.getRoot();
    }

    public void addRootClass(Class clazz) {
        OouoClassDef classDef = this.oouoClassDefFactory.create(clazz);
        String rootName = classDef.getElementName();
        this.rootClass.put(rootName, clazz);
    }

    public S2Container getContainer() {
        return this.container;
    }

    public void setContainer(S2Container container) {
        this.container = container;
    }

    public OouoClassDefFactory getOouoClassDefFactory() {
        return this.oouoClassDefFactory;
    }

    public void setOouoClassDefFactory(OouoClassDefFactory oouoClassDefFactory) {
        this.oouoClassDefFactory = oouoClassDefFactory;
    }
}

