/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.buri.oouo.reader.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.seasar.buri.oouo.reader.OouoClassDef;
import org.seasar.buri.oouo.reader.impl.OouoAccessInfo;
import org.seasar.buri.oouo.reader.impl.OouoSig;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.FieldUtil;
import org.seasar.framework.util.MethodUtil;

public class OouoClassDefImpl
implements OouoClassDef {
    private Class clazz;
    private static List fieldSigs = new ArrayList();
    private Object tgtObj;
    private Map methodMap = new HashMap();
    private String thisElementName = "";
    private Method finMethod = null;
    private Method textMethod = null;
    private Map childElement = new HashMap();
    private Map attriElement = new HashMap();
    private Map attri = new HashMap();

    public void setClass(Class clazz) {
        this.clazz = clazz;
        this.tgtObj = ClassUtil.newInstance((Class)clazz);
        Map accessDef = this.setupAccessDef(clazz);
        this.setupMethodInfo(accessDef);
    }

    private void setupMethodInfo(Map accessDef) {
        this.setupMethodNames();
        Iterator ite = accessDef.keySet().iterator();
        while (ite.hasNext()) {
            OouoAccessInfo accessInfo = (OouoAccessInfo)accessDef.get(ite.next());
            this.dispach(accessInfo);
        }
    }

    private void setupMethodNames() {
        Method[] methods = this.clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!this.isOouoMethod(methods[i])) continue;
            this.methodMap.put(methods[i].getName(), methods[i]);
        }
    }

    private boolean isOouoMethod(Method method) {
        int paramCount = method.getParameterTypes().length;
        return paramCount <= 1;
    }

    private void dispach(OouoAccessInfo accessInfo) {
        int type = accessInfo.getTypeSum();
        if (type == 64) {
            this.setThisEleName(accessInfo);
        } else if (type == 4) {
            this.attriDef(accessInfo);
        } else if (type == 6) {
            this.attriEleDef(accessInfo);
        } else if (type == 2) {
            this.elementDef(accessInfo);
        } else if (type == 128) {
            this.setFinMethod(accessInfo);
        } else if (type == 8) {
            this.setTextMethod(accessInfo);
        }
    }

    private void setTextMethod(OouoAccessInfo accessInfo) {
        this.textMethod = this.getSetupMethod(accessInfo);
    }

    private void setFinMethod(OouoAccessInfo accessInfo) {
        Method[] methods = this.clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(accessInfo.getTgtName())) continue;
            this.finMethod = methods[i];
        }
    }

    private void setThisEleName(OouoAccessInfo accessInfo) {
        OouoSig sig = (OouoSig)accessInfo.getSigSet().toArray()[0];
        this.thisElementName = (String)FieldUtil.get((Field)sig.getField(), (Object)this.tgtObj);
    }

    private void attriDef(OouoAccessInfo accessInfo) {
        this.setupAccessInfoToMap(accessInfo, this.attri);
    }

    private void attriEleDef(OouoAccessInfo accessInfo) {
        this.attriEleImpl(accessInfo, 2, this.attriElement);
    }

    private void attriEleImpl(OouoAccessInfo accessInfo, int eleType, Map tgtMap) {
        Iterator ite = accessInfo.getSigSet().iterator();
        Map<String, Method> attriMap = new HashMap<String, Method>();
        String att = "";
        Method tgtMethod = null;
        while (ite.hasNext()) {
            OouoSig sig = (OouoSig)ite.next();
            String val = (String)FieldUtil.get((Field)sig.getField(), (Object)this.tgtObj);
            if (sig.getAction() == eleType) {
                String ele = val;
                if (!tgtMap.containsKey(ele)) {
                    tgtMap.put(ele, attriMap);
                } else {
                    attriMap = (Map)tgtMap.get(ele);
                }
            }
            if (sig.getAction() != 4) continue;
            att = val;
            tgtMethod = this.getSetupMethod(accessInfo);
        }
        attriMap.put(att, tgtMethod);
    }

    private void elementDef(OouoAccessInfo accessInfo) {
        this.setupAccessInfoToMap(accessInfo, this.childElement);
    }

    private void setupAccessInfoToMap(OouoAccessInfo accessInfo, Map tgtMap) {
        OouoSig sig = (OouoSig)accessInfo.getSigSet().toArray()[0];
        String val = (String)FieldUtil.get((Field)sig.getField(), (Object)this.tgtObj);
        Method tgtMethod = this.getSetupMethod(accessInfo);
        tgtMap.put(val, tgtMethod);
    }

    private Method getSetupMethod(OouoAccessInfo accessInfo) {
        String tgtName = accessInfo.getTgtName();
        Method tgtMethod = null;
        if (this.methodMap.containsKey(tgtName)) {
            tgtMethod = (Method)this.methodMap.get(tgtName);
        }
        return tgtMethod;
    }

    private Map setupAccessDef(Class clazz) {
        Field[] field = clazz.getFields();
        HashMap accessDef = new HashMap();
        for (int i = 0; i < field.length; ++i) {
            Field tgt = field[i];
            this.fieldProcess(tgt, accessDef);
        }
        return accessDef;
    }

    private void fieldProcess(Field tgt, Map accessDef) {
        if (tgt.getType().equals(String.class)) {
            OouoSig sig = this.findTgtFieldName(tgt);
            if (sig == null) {
                return;
            }
            this.createOouoAccessInfo(tgt, sig, accessDef);
        }
    }

    private void createOouoAccessInfo(Field tgt, OouoSig sig, Map accessDef) {
        String tgtName = tgt.getName().replaceAll(sig.getSig(), "");
        OouoAccessInfo accessInfo = null;
        if (accessDef.containsKey(tgtName)) {
            accessInfo = (OouoAccessInfo)accessDef.get(tgtName);
        } else {
            accessInfo = new OouoAccessInfo();
            accessInfo.setTgtName(tgtName);
            accessDef.put(tgtName, accessInfo);
        }
        accessInfo.getSigSet().add(sig);
        accessInfo.addType(sig);
    }

    private OouoSig findTgtFieldName(Field tgt) {
        Iterator ite = fieldSigs.iterator();
        while (ite.hasNext()) {
            OouoSig sig = (OouoSig)ite.next();
            if (tgt.getName().indexOf(sig.getSig()) < 0) continue;
            return sig.copy(tgt);
        }
        return null;
    }

    public boolean isChildElement(String elename) {
        return this.childElement.containsKey(elename);
    }

    public String getElementName() {
        return this.thisElementName;
    }

    public Object getChildObject(String name) {
        Method tgtMethod = this.getSetterMethod(name);
        if (tgtMethod.getParameterTypes().length == 0) {
            return null;
        }
        Class<?> clazz = tgtMethod.getParameterTypes()[0];
        Object obj = ClassUtil.newInstance(clazz);
        return obj;
    }

    private Method getSetterMethod(String name) {
        Method tgtMethod = null;
        if (this.childElement.containsKey(name)) {
            tgtMethod = (Method)this.childElement.get(name);
        }
        return tgtMethod;
    }

    public void setChild(Object now, String name, Object child) {
        Method tgtMethod = this.getSetterMethod(name);
        if (child != null) {
            MethodUtil.invoke((Method)tgtMethod, (Object)now, (Object[])new Object[]{child});
        } else {
            MethodUtil.invoke((Method)tgtMethod, (Object)now, null);
        }
    }

    public boolean isChildAttribute(String name, String type) {
        Map types = null;
        if (this.attriElement.containsKey(name)) {
            types = (Map)this.attriElement.get(name);
        }
        return types != null && types.containsKey(type);
    }

    public void setChildAttribute(Object now, String name, String type, String value) {
        Method tgtMethod = null;
        Map types = null;
        if (this.attriElement.containsKey(name)) {
            types = (Map)this.attriElement.get(name);
        }
        if (types != null && types.containsKey(type)) {
            tgtMethod = (Method)types.get(type);
            MethodUtil.invoke((Method)tgtMethod, (Object)now, (Object[])new Object[]{value});
        }
    }

    public boolean isAttribute(String type) {
        return this.attri.containsKey(type);
    }

    public void setAttribute(Object now, String type, String value) {
        Method method = (Method)this.attri.get(type);
        if (method.getParameterTypes()[0].equals(String.class)) {
            MethodUtil.invoke((Method)method, (Object)now, (Object[])new Object[]{value});
        }
    }

    public Class getTgtClass() {
        return this.clazz;
    }

    public boolean isCallFinMethod() {
        return this.finMethod != null;
    }

    public void fin(Object now, Object parent) {
        if (this.finMethod.getParameterTypes().length == 0) {
            MethodUtil.invoke((Method)this.finMethod, (Object)now, null);
        } else {
            MethodUtil.invoke((Method)this.finMethod, (Object)now, (Object[])new Object[]{parent});
        }
    }

    public boolean isSetTextMethod() {
        return this.textMethod != null;
    }

    public void setText(Object now, String value) {
        MethodUtil.invoke((Method)this.textMethod, (Object)now, (Object[])new Object[]{value});
    }

    static {
        OouoSig sig = new OouoSig();
        sig.setAction(4);
        sig.setSig("_ATTRI");
        fieldSigs.add(sig);
        sig = new OouoSig();
        sig.setAction(2);
        sig.setSig("_ELEMENT");
        fieldSigs.add(sig);
        sig = new OouoSig();
        sig.setAction(64);
        sig.setSig("OOUOTHIS");
        fieldSigs.add(sig);
        sig = new OouoSig();
        sig.setAction(128);
        sig.setSig("_OOUOFIN");
        fieldSigs.add(sig);
        sig = new OouoSig();
        sig.setAction(8);
        sig.setSig("_OOUOTEXT");
        fieldSigs.add(sig);
    }
}

