/*
 * Decompiled with CFR 0.152.
 */
package jp.starlogic.util.datetime;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import jp.ne.dion.h3.sakatsu.addinbox.KtHoliday;
import jp.starlogic.util.datetime.CalendarUtil;
import jp.starlogic.util.datetime.DateUtil;
import jp.starlogic.util.datetime.TimeUtil;

public class UtilCalendar
extends GregorianCalendar {
    private static final long serialVersionUID = -4210613461645866056L;

    public static Calendar getInstance() {
        return new UtilCalendar();
    }

    public static Calendar getInstance(Date date) {
        Calendar calendar = UtilCalendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    protected UtilCalendar() {
    }

    protected UtilCalendar(TimeZone zone, Locale aLocale) {
        super(zone, aLocale);
    }

    public Object clone() {
        Calendar calendar = UtilCalendar.getInstance();
        calendar.setTimeInMillis(this.getTimeInMillis());
        return calendar;
    }

    public Calendar clearTime() {
        Calendar calendar = TimeUtil.clearTime(this);
        this.setTimeInMillis(calendar.getTimeInMillis());
        return this;
    }

    public Calendar setMaxTime() {
        Calendar calendar = TimeUtil.setMaxTime(this);
        this.setTimeInMillis(calendar.getTimeInMillis());
        return this;
    }

    public static Calendar setSqlMax() {
        Calendar calendar = DateUtil.getSQLMaxCalendar();
        calendar.setTimeInMillis(calendar.getTimeInMillis());
        return calendar;
    }

    public static Calendar setSqlMin() {
        Calendar calendar = DateUtil.getSQLMinCalendar();
        calendar.setTimeInMillis(calendar.getTimeInMillis());
        return calendar;
    }

    public Calendar clearMilliSecond() {
        CalendarUtil.setActualMinimum(this, 14);
        return this;
    }

    public Calendar addMilliSecond(int val) {
        this.add(14, val);
        return this;
    }

    public Calendar rollMilliSecond(int val) {
        this.roll(14, val);
        return this;
    }

    public Calendar setMilliSecond(int millisec) {
        this.set(14, millisec);
        return this;
    }

    public Calendar setMaxMilliSecond() {
        CalendarUtil.setActualMaximum(this, 14);
        return this;
    }

    public int getMilliSecond() {
        return this.get(14);
    }

    public Calendar clearSecond() {
        CalendarUtil.setActualMinimum(this, 13);
        return this;
    }

    public Calendar addSecond(int val) {
        this.add(13, val);
        return this;
    }

    public Calendar rollSecond(int val) {
        this.roll(13, val);
        return this;
    }

    public Calendar setSecond(int sec) {
        this.set(13, sec);
        return this;
    }

    public Calendar setMaxSecond() {
        CalendarUtil.setActualMaximum(this, 13);
        return this;
    }

    public int getSecond() {
        return this.get(13);
    }

    public Calendar clearMinute() {
        CalendarUtil.setActualMinimum(this, 12);
        return this;
    }

    public Calendar addMinute(int val) {
        this.add(12, val);
        return this;
    }

    public Calendar rollMinute(int val) {
        this.roll(12, val);
        return this;
    }

    public Calendar setMinute(int minute) {
        this.set(12, minute);
        return this;
    }

    public Calendar setMaxMinute() {
        CalendarUtil.setActualMaximum(this, 12);
        return this;
    }

    public int getMinute() {
        return this.get(12);
    }

    public Calendar clearHourOfDay() {
        CalendarUtil.setActualMinimum(this, 11);
        return this;
    }

    public Calendar addHourOfDay(int val) {
        this.add(11, val);
        return this;
    }

    public Calendar rollHourOfDay(int val) {
        this.roll(11, val);
        return this;
    }

    public Calendar setHourOfDay(int hour) {
        this.set(11, hour);
        return this;
    }

    public Calendar setMaxHourOfDay() {
        CalendarUtil.setActualMaximum(this, 11);
        return this;
    }

    public int getHourOfDay() {
        return this.get(11);
    }

    public Calendar clearHour() {
        CalendarUtil.setActualMinimum(this, 10);
        return this;
    }

    public Calendar addHour(int val) {
        this.add(10, val);
        return this;
    }

    public Calendar rollHour(int val) {
        this.roll(10, val);
        return this;
    }

    public Calendar setHour(int hour) {
        this.set(10, hour);
        return this;
    }

    public Calendar setMaxHour() {
        CalendarUtil.setActualMaximum(this, 10);
        return this;
    }

    public int getHour() {
        return this.get(10);
    }

    public Calendar getFirstDayOfMonth() {
        CalendarUtil.setActualMinimum(this, 5);
        return this;
    }

    public Calendar addDayOfMonth(int val) {
        this.add(5, val);
        return this;
    }

    public Calendar rollDayOfMonth(int val) {
        this.roll(5, val);
        return this;
    }

    public Calendar setDayOfMonth(int val) {
        this.set(5, val);
        return this;
    }

    public Calendar getLastDayOfMonth() {
        CalendarUtil.setActualMaximum(this, 5);
        return this;
    }

    public int getDayOfMonth() {
        return this.get(5);
    }

    public Calendar prevDay() {
        return this.addDayOfMonth(-1);
    }

    public Calendar nextDay() {
        return this.addDayOfMonth(1);
    }

    public Calendar nextWeekday() {
        UtilCalendar checkDay = (UtilCalendar)this.clone();
        do {
            checkDay.nextDay();
        } while (checkDay.isHoliday() || checkDay.isWeekEnd());
        this.setTimeInMillis(checkDay.getTimeInMillis());
        return this;
    }

    public Calendar prevWeekday() {
        UtilCalendar checkDay = (UtilCalendar)this.clone();
        do {
            checkDay.prevDay();
        } while (checkDay.isHoliday() || checkDay.isWeekEnd());
        this.setTimeInMillis(checkDay.getTimeInMillis());
        return this;
    }

    public Calendar addWeekday(int val) {
        for (int i = 0; i < val; ++i) {
            this.nextWeekday();
        }
        return this;
    }

    public Calendar subWeekday(int val) {
        for (int i = 0; i < val; ++i) {
            this.prevWeekday();
        }
        return this;
    }

    public Calendar nextHoliday() {
        UtilCalendar checkDay = (UtilCalendar)this.clone();
        do {
            checkDay.nextDay();
        } while (!checkDay.isHoliday() && !checkDay.isWeekEnd());
        this.setTimeInMillis(checkDay.getTimeInMillis());
        return this;
    }

    public Calendar prevHoliday() {
        UtilCalendar checkDay = (UtilCalendar)this.clone();
        do {
            checkDay.prevDay();
        } while (!checkDay.isHoliday() && !checkDay.isWeekEnd());
        this.setTimeInMillis(checkDay.getTimeInMillis());
        return this;
    }

    public Calendar addHoliday(int val) {
        for (int i = 0; i < val; ++i) {
            this.nextHoliday();
        }
        return this;
    }

    public Calendar subHoliday(int val) {
        for (int i = 0; i < val; ++i) {
            this.prevHoliday();
        }
        return this;
    }

    public Calendar getFirstMonth() {
        CalendarUtil.setActualMinimum(this, 2);
        return this;
    }

    public Calendar addMonth(int val) {
        this.add(2, val);
        return this;
    }

    public Calendar rollMonth(int val) {
        this.roll(2, val);
        return this;
    }

    public Calendar setMonth(int val) {
        this.set(2, val);
        return this;
    }

    public Calendar setNaturalMonth(int val) {
        this.set(2, val - 1);
        return this;
    }

    public Calendar getLastMonth() {
        CalendarUtil.setActualMaximum(this, 2);
        return this;
    }

    public int getMonth() {
        return this.get(2);
    }

    public int getNaturalMonth() {
        return this.get(2) + 1;
    }

    public Calendar prevMonth() {
        return this.addMonth(-1);
    }

    public Calendar nextMonth() {
        return this.addMonth(1);
    }

    public Calendar getFirstYear() {
        CalendarUtil.setActualMinimum(this, 1);
        return this;
    }

    public Calendar addYear(int val) {
        this.add(1, val);
        return this;
    }

    public Calendar rollYear(int val) {
        this.roll(1, val);
        return this;
    }

    public Calendar setYear(int val) {
        this.set(1, val);
        return this;
    }

    public Calendar getLastYear() {
        CalendarUtil.setActualMaximum(this, 1);
        return this;
    }

    public int getYear() {
        return this.get(1);
    }

    public Calendar prevYear() {
        return this.addYear(-1);
    }

    public Calendar nextYear() {
        return this.addYear(1);
    }

    public boolean isHoliday() {
        boolean isHoliday = this.getHolidayName().length() > 0;
        return isHoliday;
    }

    public String getHolidayName() {
        String holidayName = KtHoliday.getHolidayName(this);
        return holidayName;
    }

    public int getDayOfWeek() {
        return this.get(7);
    }

    public String getWeekString() {
        String[] weekStr = new String[]{"", "\u65e5", "\u6708", "\u706b", "\u6c34", "\u6728", "\u91d1", "\u571f"};
        String ret = weekStr[this.getDayOfWeek()];
        return ret;
    }

    public boolean isWeekEnd() {
        int weekNo = this.getDayOfWeek();
        if (weekNo == 1) {
            return true;
        }
        return weekNo == 7;
    }
}

