/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.dialect.postgresql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.Validate;
import org.jiemamy.dialect.DefaultDbObjectImportVisitor;
import org.jiemamy.dialect.Dialect;
import org.jiemamy.dialect.postgresql.PostgreSqlDialect;
import org.jiemamy.model.view.SimpleJmView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSqlDbObjectImportVisitor
extends DefaultDbObjectImportVisitor {
    private static Logger logger = LoggerFactory.getLogger(PostgreSqlDbObjectImportVisitor.class);
    private String schema;

    public PostgreSqlDbObjectImportVisitor(PostgreSqlDialect dialect) {
        super((Dialect)dialect);
    }

    protected SimpleJmView createView(String viewName) throws SQLException {
        Validate.notNull((Object)viewName);
        SimpleJmView view = new SimpleJmView();
        view.setName(viewName);
        try {
            Connection connection = this.getMeta().getMetaData().getConnection();
            String definition = this.getViewDefinition(connection, viewName);
            view.setDefinition(definition);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("exception is thrown", (Throwable)e);
        }
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getViewDefinition(Connection conn, String viewName) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement("SELECT * FROM pg_views WHERE schemaname = ? AND viewname = ?;");
            ps.setString(1, this.schema);
            ps.setString(2, viewName);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                String string = rs.getString("definition");
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    void setSchema(String schema) {
        this.schema = schema;
    }
}

