/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils;

import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang.StringUtils;
import org.jiemamy.JiemamyContext;
import org.jiemamy.JmMetadata;
import org.jiemamy.composer.ImportException;
import org.jiemamy.composer.importer.DbImportConfig;
import org.jiemamy.composer.importer.DbImporter;
import org.jiemamy.model.DbObject;
import org.jiemamy.model.ModelConsistencyException;
import org.jiemamy.model.index.JmIndex;
import org.jiemamy.model.table.JmTable;
import org.jiemamy.model.view.JmView;
import org.jiemamy.utils.DbObjectDependencyCalculator;
import org.jiemamy.utils.collection.ListUtil;
import org.jiemamy.utils.sql.DriverNotFoundException;
import org.jiemamy.utils.sql.DriverUtil;
import org.jiemamy.utils.sql.SqlExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DbCleaner {
    private static Logger logger = LoggerFactory.getLogger(DbCleaner.class);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void clean(DbImportConfig config) throws ImportException {
        List<DbObject> orderedDbObjects;
        logger.info("clean: " + config.getUri());
        JiemamyContext context = new JiemamyContext();
        DbImporter dbImporter = new DbImporter();
        dbImporter.importModel(context, config);
        try {
            orderedDbObjects = DbObjectDependencyCalculator.getSortedEntityList(context);
        }
        catch (ModelConsistencyException e) {
            throw new ImportException("imported model is inconsistent.", e);
        }
        ListUtil.reverse(orderedDbObjects);
        Connection connection = null;
        try {
            Properties props = new Properties();
            props.setProperty("user", config.getUsername());
            props.setProperty("password", config.getPassword());
            URL[] paths = config.getDriverJarPaths();
            String className = config.getDriverClassName();
            connection = DbCleaner.connect(config, props, paths, className);
            SqlExecutor sqlExecuter = DbCleaner.getExecutor(connection);
            JmMetadata metadata = context.getMetadata();
            if (metadata != null && !StringUtils.isEmpty((String)metadata.getSchemaName())) {
                sqlExecuter.execute(String.format("DROP SCHEMA \"%s\";", metadata.getSchemaName()));
            }
            for (DbObject dbObject : orderedDbObjects) {
                String type = null;
                if (dbObject instanceof JmTable) {
                    type = "TABLE";
                } else if (dbObject instanceof JmView) {
                    type = "VIEW";
                } else if (dbObject instanceof JmIndex) {
                    type = "INDEX";
                }
                if (type != null) {
                    String statement = String.format("DROP %s %s;", type, dbObject.getName());
                    sqlExecuter.execute(statement);
                    continue;
                }
                logger.warn("unsupported dbObject: " + dbObject.getClass().getName());
            }
        }
        catch (DriverNotFoundException e) {
            try {
                throw new ImportException(e);
                catch (InstantiationException e2) {
                    throw new ImportException(e2);
                }
                catch (IllegalAccessException e3) {
                    throw new ImportException(e3);
                }
                catch (IOException e4) {
                    throw new ImportException(e4);
                }
                catch (SQLException e5) {
                    throw new ImportException(e5);
                }
                catch (Exception e6) {
                    throw new ImportException(e6);
                }
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(connection);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((Connection)connection);
    }

    static Connection connect(DbImportConfig config, Properties props, URL[] paths, String className) throws InstantiationException, IllegalAccessException, DriverNotFoundException, IOException, SQLException {
        Driver driver = DriverUtil.getDriverInstance((URL[])paths, (String)className);
        return driver.connect(config.getUri(), props);
    }

    static SqlExecutor getExecutor(Connection connection) {
        return new SqlExecutor(connection);
    }

    private DbCleaner() {
    }
}

