/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.model.index;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jiemamy.dddbase.EntityRef;
import org.jiemamy.model.column.JmColumn;
import org.jiemamy.model.index.JmIndexColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleJmIndexColumn
implements JmIndexColumn {
    private final EntityRef<? extends JmColumn> columnRef;
    private final JmIndexColumn.SortOrder sortOrder;

    public static SimpleJmIndexColumn of(JmColumn column) {
        Validate.notNull((Object)column);
        return new SimpleJmIndexColumn(column.toReference());
    }

    public static SimpleJmIndexColumn of(JmColumn column, JmIndexColumn.SortOrder sortOrder) {
        Validate.notNull((Object)((Object)sortOrder));
        return new SimpleJmIndexColumn(column.toReference(), sortOrder);
    }

    public SimpleJmIndexColumn(EntityRef<? extends JmColumn> columnRef) {
        this(columnRef, null);
    }

    public SimpleJmIndexColumn(EntityRef<? extends JmColumn> columnRef, JmIndexColumn.SortOrder sortOrder) {
        Validate.notNull(columnRef);
        this.columnRef = columnRef;
        this.sortOrder = sortOrder;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimpleJmIndexColumn)) {
            return false;
        }
        SimpleJmIndexColumn other = (SimpleJmIndexColumn)obj;
        if (!this.columnRef.equals(other.columnRef)) {
            return false;
        }
        return !(this.sortOrder == null ? other.sortOrder != null : !this.sortOrder.equals((Object)other.sortOrder));
    }

    @Override
    public EntityRef<? extends JmColumn> getColumnRef() {
        assert (this.columnRef != null);
        return this.columnRef;
    }

    @Override
    public JmIndexColumn.SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.columnRef.hashCode();
        result = 31 * result + (this.sortOrder == null ? 0 : this.sortOrder.hashCode());
        return result;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

