/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.model.datatype;

import com.google.common.collect.Maps;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.codehaus.staxmate.in.SMEvent;
import org.jiemamy.model.datatype.RawTypeCategory;
import org.jiemamy.model.datatype.SimpleRawTypeDescriptor;
import org.jiemamy.serializer.SerializationException;
import org.jiemamy.serializer.stax.DeserializationContext;
import org.jiemamy.serializer.stax.JiemamyCursor;
import org.jiemamy.serializer.stax.JiemamyOutputContainer;
import org.jiemamy.serializer.stax.JiemamyOutputElement;
import org.jiemamy.serializer.stax.SerializationContext;
import org.jiemamy.serializer.stax.StaxDirector;
import org.jiemamy.serializer.stax.StaxHandler;
import org.jiemamy.xml.CoreQName;
import org.jiemamy.xml.JiemamyQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleRawTypeDescriptorStaxHandler
extends StaxHandler<SimpleRawTypeDescriptor> {
    private static Logger logger = LoggerFactory.getLogger(SimpleRawTypeDescriptorStaxHandler.class);

    public SimpleRawTypeDescriptorStaxHandler(StaxDirector director) {
        super(director);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SimpleRawTypeDescriptor handleDeserialization(DeserializationContext dctx) throws SerializationException {
        Validate.notNull((Object)dctx);
        try {
            Validate.isTrue((dctx.peek().getCurrEvent() == SMEvent.START_ELEMENT ? 1 : 0) != 0);
            Validate.isTrue((boolean)dctx.peek().isQName(CoreQName.TYPE_DESC));
            JiemamyCursor cursor = dctx.peek();
            RawTypeCategory category = RawTypeCategory.UNKNOWN;
            String typeName = "UNKNOWN";
            HashMap params = Maps.newHashMap();
            JiemamyCursor childCursor = cursor.childElementCursor();
            dctx.push(childCursor);
            do {
                JiemamyCursor parameterCursor;
                block10: {
                    childCursor.advance();
                    if (childCursor.getCurrEvent() == SMEvent.START_ELEMENT) {
                        if (childCursor.isQName(CoreQName.TYPE_CATEGORY)) {
                            String text = childCursor.collectDescendantText(false);
                            if (StringUtils.isEmpty((String)text)) continue;
                            category = RawTypeCategory.valueOf(text);
                            continue;
                        }
                        if (childCursor.isQName(CoreQName.TYPE_NAME)) {
                            typeName = childCursor.collectDescendantText(false);
                            continue;
                        }
                        if (childCursor.isQName(CoreQName.PARAMETERS)) {
                            parameterCursor = childCursor.childElementCursor();
                            break block10;
                        } else {
                            logger.warn("UNKNOWN ELEMENT: {}", (Object)childCursor.getQName().toString());
                            continue;
                        }
                    }
                    if (childCursor.getCurrEvent() == null) continue;
                    logger.warn("UNKNOWN EVENT: {}", (Object)childCursor.getCurrEvent());
                    continue;
                }
                while (parameterCursor.getNext() != null) {
                    if (!parameterCursor.isQName(CoreQName.PARAMETER)) {
                        logger.warn("unexpected: " + parameterCursor.getQName());
                        continue;
                    }
                    params.put(parameterCursor.getAttrValue(CoreQName.PARAMETER_KEY), parameterCursor.collectDescendantText(false));
                }
            } while (childCursor.getCurrEvent() != null);
            dctx.pop();
            return new SimpleRawTypeDescriptor(category, typeName, new String[0]);
        }
        catch (XMLStreamException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public void handleSerialization(SimpleRawTypeDescriptor model, SerializationContext sctx) throws SerializationException {
        Validate.notNull((Object)model);
        Validate.notNull((Object)sctx);
        JiemamyOutputContainer parent = sctx.peek();
        try {
            JiemamyOutputElement element = parent.addElement(CoreQName.TYPE_DESC);
            element.addElementAndCharacters((JiemamyQName)CoreQName.TYPE_CATEGORY, model.getCategory());
            element.addElementAndCharacters((JiemamyQName)CoreQName.TYPE_NAME, model.getTypeName());
        }
        catch (XMLStreamException e) {
            throw new SerializationException(e);
        }
    }
}

