/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.model.datatype;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.Validate;
import org.jiemamy.model.datatype.RawTypeCategory;
import org.jiemamy.model.datatype.RawTypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleRawTypeDescriptor
implements RawTypeDescriptor {
    public static final RawTypeDescriptor UNKNOWN = new RawTypeDescriptor(){

        @Override
        public Collection<String> getAliasTypeNames() {
            return Collections.emptyList();
        }

        @Override
        public RawTypeCategory getCategory() {
            return RawTypeCategory.UNKNOWN;
        }

        @Override
        public String getTypeName() {
            return "UNKNOWN";
        }

        public String toString() {
            return "UNKNOWN";
        }
    };
    private String typeName;
    private RawTypeCategory category;
    private final String[] aliasTypeNames;

    private static <T> T notNull(T object) {
        Validate.notNull(object);
        return object;
    }

    public SimpleRawTypeDescriptor(RawTypeCategory category) {
        this(category, SimpleRawTypeDescriptor.notNull(category).name(), new String[0]);
    }

    public SimpleRawTypeDescriptor(RawTypeCategory category, String typeName, String ... aliasTypeNames) {
        Validate.notNull((Object)((Object)category));
        Validate.notNull((Object)typeName);
        Validate.noNullElements((Object[])aliasTypeNames);
        this.category = category;
        this.typeName = typeName;
        this.aliasTypeNames = aliasTypeNames;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RawTypeDescriptor other = (RawTypeDescriptor)obj;
        if (this.category != other.getCategory()) {
            return false;
        }
        return this.typeName.equals(other.getTypeName());
    }

    @Override
    public Collection<String> getAliasTypeNames() {
        return Lists.newArrayList((Object[])this.aliasTypeNames);
    }

    @Override
    public RawTypeCategory getCategory() {
        return this.category;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.category.hashCode();
        result = 31 * result + this.typeName.hashCode();
        return result;
    }

    public String toString() {
        return this.typeName + "(" + (Object)((Object)this.category) + ")";
    }
}

