/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.model.datatype;

import org.apache.commons.lang.Validate;
import org.jiemamy.model.datatype.DataType;
import org.jiemamy.model.datatype.RawTypeCategory;
import org.jiemamy.model.datatype.RawTypeDescriptor;
import org.jiemamy.model.datatype.SimpleRawTypeDescriptor;
import org.jiemamy.model.datatype.TypeParameterKey;
import org.jiemamy.model.parameter.ParameterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleDataType
implements DataType {
    private ParameterMap params = new ParameterMap();
    private RawTypeDescriptor rawTypeDescriptor;

    public static SimpleDataType of(RawTypeCategory category) {
        Validate.notNull((Object)((Object)category));
        return new SimpleDataType(new SimpleRawTypeDescriptor(category));
    }

    public SimpleDataType(RawTypeDescriptor rawTypeDescriptor) {
        Validate.notNull((Object)rawTypeDescriptor);
        this.rawTypeDescriptor = rawTypeDescriptor;
    }

    @Override
    public SimpleDataType clone() {
        try {
            SimpleDataType clone = (SimpleDataType)super.clone();
            clone.params = this.params.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("clone not supported", e);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleDataType other = (SimpleDataType)obj;
        if (!this.params.equals(other.params)) {
            return false;
        }
        return this.rawTypeDescriptor.equals(other.rawTypeDescriptor);
    }

    @Override
    public <T> T getParam(TypeParameterKey<T> key) {
        return this.params.get(key);
    }

    @Override
    public ParameterMap getParams() {
        return this.params.clone();
    }

    @Override
    public RawTypeDescriptor getRawTypeDescriptor() {
        return this.rawTypeDescriptor;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.params.hashCode();
        result = 31 * result + this.rawTypeDescriptor.hashCode();
        return result;
    }

    public void putParam(String key, String value) {
        Validate.notNull((Object)key);
        Validate.notNull((Object)value);
        this.params.put(key, value);
    }

    public <T> void putParam(TypeParameterKey<T> key, T value) {
        Validate.notNull(key);
        Validate.notNull(value);
        this.params.put(key, value);
    }

    public void removeParam(TypeParameterKey<?> key) {
        Validate.notNull(key);
        this.params.remove(key);
    }

    public void setRawTypeDescriptor(RawTypeDescriptor rawTypeDescriptor) {
        this.rawTypeDescriptor = rawTypeDescriptor;
    }

    public String toString() {
        return this.rawTypeDescriptor.toString() + this.params.toString();
    }
}

