/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.model;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.Validate;
import org.jiemamy.JiemamyContext;
import org.jiemamy.dddbase.AbstractEntity;
import org.jiemamy.dddbase.DefaultEntityRef;
import org.jiemamy.dddbase.Entity;
import org.jiemamy.dddbase.EntityRef;
import org.jiemamy.model.DbObject;
import org.jiemamy.model.parameter.ParameterKey;
import org.jiemamy.model.parameter.ParameterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleDbObject
extends AbstractEntity
implements DbObject {
    private String name;
    private String logicalName;
    private String description;
    protected ParameterMap params = new ParameterMap();

    public SimpleDbObject(UUID id) {
        super(id);
    }

    @Override
    public SimpleDbObject clone() {
        SimpleDbObject clone = (SimpleDbObject)super.clone();
        return clone;
    }

    @Override
    public Set<DbObject> findSubDbObjectsNonRecursive(JiemamyContext context) {
        HashSet collecter = Sets.newHashSet();
        for (DbObject dbObject : context.getDbObjects()) {
            if (!dbObject.isSubDbObjectsNonRecursiveOf(this, context)) continue;
            collecter.add(dbObject);
        }
        return collecter;
    }

    @Override
    public Set<DbObject> findSuperDbObjectsNonRecursive(Set<DbObject> dbObjects) {
        Validate.notNull(dbObjects);
        return Collections.emptySet();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getLogicalName() {
        return this.logicalName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public <T> T getParam(ParameterKey<T> key) {
        return this.params.get(key);
    }

    @Override
    public ParameterMap getParams() {
        return this.params.clone();
    }

    @Override
    public boolean isSubDbObjectsNonRecursiveOf(DbObject target, JiemamyContext context) {
        return false;
    }

    public <T> void putParam(ParameterKey<T> key, T value) {
        this.params.put(key, value);
    }

    public void removeParam(ParameterKey<?> key) {
        this.params.remove(key);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLogicalName(String logicalName) {
        this.logicalName = logicalName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EntityRef<? extends SimpleDbObject> toReference() {
        return new DefaultEntityRef((Entity)this);
    }

    public String toString() {
        return super.toString() + "[" + this.name + "]";
    }
}

