/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.dialect;

import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.jiemamy.JiemamyContext;
import org.jiemamy.dialect.DbObjectImportVisitor;
import org.jiemamy.dialect.Dialect;
import org.jiemamy.dialect.ParseMetadataConfig;
import org.jiemamy.model.DbObject;
import org.jiemamy.model.column.JmColumn;
import org.jiemamy.model.column.SimpleJmColumn;
import org.jiemamy.model.constraint.JmConstraint;
import org.jiemamy.model.constraint.SimpleJmNotNullConstraint;
import org.jiemamy.model.constraint.SimpleJmPrimaryKeyConstraint;
import org.jiemamy.model.datatype.DataType;
import org.jiemamy.model.datatype.RawTypeCategory;
import org.jiemamy.model.datatype.RawTypeDescriptor;
import org.jiemamy.model.datatype.SimpleDataType;
import org.jiemamy.model.datatype.SimpleRawTypeDescriptor;
import org.jiemamy.model.datatype.TypeParameterKey;
import org.jiemamy.model.table.SimpleJmTable;
import org.jiemamy.model.view.SimpleJmView;
import org.jiemamy.utils.sql.metadata.ColumnMeta;
import org.jiemamy.utils.sql.metadata.PrimaryKeyMeta;
import org.jiemamy.utils.sql.metadata.TableMeta;
import org.jiemamy.utils.sql.metadata.TypeSafeDatabaseMetaData;
import org.jiemamy.utils.sql.metadata.TypeSafeResultSet;
import org.jiemamy.utils.visitor.AbstractCollectionVisitor;
import org.jiemamy.utils.visitor.AbstractTypeSafeResultSetVisitor;
import org.jiemamy.utils.visitor.ForEachUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDbObjectImportVisitor
extends AbstractCollectionVisitor<TableMeta, Void, SQLException>
implements DbObjectImportVisitor {
    private static Logger logger = LoggerFactory.getLogger(DefaultDbObjectImportVisitor.class);
    private static final String[] DEFAULT_TYPES = new String[]{"TABLE", "VIEW"};
    private TypeSafeDatabaseMetaData meta;
    private JiemamyContext context;
    private Collection<String> entityTypes;
    private Collection<String> selectedEntities;
    private ParseMetadataConfig config;
    private final Dialect dialect;

    public DefaultDbObjectImportVisitor(Dialect dialect) {
        Validate.notNull((Object)dialect);
        this.dialect = dialect;
    }

    @Override
    public void intialize(TypeSafeDatabaseMetaData meta, JiemamyContext context, ParseMetadataConfig config) {
        Validate.notNull((Object)meta);
        Validate.notNull((Object)context);
        Validate.notNull((Object)config);
        this.meta = meta;
        this.context = context;
        this.config = config;
        String[] entityTypesValue = config.getEntityTypes();
        if (entityTypesValue == null) {
            entityTypesValue = DEFAULT_TYPES;
        }
        this.entityTypes = Arrays.asList(entityTypesValue);
        Object[] selectedEntitiesValue = config.getSelectedEntities();
        this.selectedEntities = ArrayUtils.isEmpty((Object[])selectedEntitiesValue) ? null : Arrays.asList(selectedEntitiesValue);
    }

    public Void visit(TableMeta tableMeta) throws SQLException {
        DbObject dbObject;
        Validate.notNull((Object)tableMeta);
        if (this.entityTypes.contains(tableMeta.tableType) && (this.selectedEntities == null || this.selectedEntities.contains(tableMeta.tableName)) && (dbObject = this.createDbObject(tableMeta)) != null) {
            this.context.store(dbObject);
        }
        return null;
    }

    protected DbObject createDbObject(TableMeta tableMeta) throws SQLException {
        Validate.notNull((Object)tableMeta);
        SimpleJmTable result = null;
        logger.debug("type = " + tableMeta.tableType + "(" + tableMeta.tableName + ")");
        if ("TABLE".equals(tableMeta.tableType)) {
            result = this.createTable(tableMeta.tableName);
        } else if ("VIEW".equals(tableMeta.tableType)) {
            result = this.createView(tableMeta.tableName);
        }
        if (result == null) {
            return null;
        }
        if (!StringUtils.isEmpty((String)tableMeta.remarks)) {
            result.setDescription(tableMeta.remarks);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SimpleJmTable createTable(String tableName) throws SQLException {
        Validate.notNull((Object)tableName);
        SimpleJmTable table = new SimpleJmTable();
        table.setName(tableName);
        TypeSafeResultSet columnsResult = null;
        TypeSafeResultSet keysResult = null;
        try {
            columnsResult = this.getMeta().getColumns("", this.config.getSchema(), tableName, "%");
            ForEachUtil.accept((TypeSafeResultSet)columnsResult, (ForEachUtil.TypeSafeResultSetVisitor)new ColumnMetaVisitor(table));
            keysResult = this.getMeta().getPrimaryKeys("", this.config.getSchema(), tableName);
            ForEachUtil.accept((TypeSafeResultSet)keysResult, (ForEachUtil.TypeSafeResultSetVisitor)new PrimaryKeyMetaVisitor(table));
        }
        finally {
            this.closeQuietly(columnsResult);
            this.closeQuietly(keysResult);
        }
        return table;
    }

    protected SimpleJmView createView(String viewName) throws SQLException {
        Validate.notNull((Object)viewName);
        String definition = "VIEW DEFINITION (not implemented)";
        SimpleJmView view = new SimpleJmView();
        view.setName(viewName);
        view.setDefinition(definition);
        return view;
    }

    protected TypeSafeDatabaseMetaData getMeta() {
        return this.meta;
    }

    private void closeQuietly(TypeSafeResultSet<?> resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PrimaryKeyMetaVisitor
    extends AbstractTypeSafeResultSetVisitor<PrimaryKeyMeta, Boolean, SQLException> {
        private SimpleJmPrimaryKeyConstraint primaryKey;
        private final SimpleJmTable table;

        private PrimaryKeyMetaVisitor(SimpleJmTable table) {
            Validate.notNull((Object)table);
            this.table = table;
            this.primaryKey = (SimpleJmPrimaryKeyConstraint)table.getPrimaryKey();
        }

        public Boolean visit(PrimaryKeyMeta element) {
            Validate.notNull((Object)element);
            if (this.primaryKey == null) {
                this.primaryKey = new SimpleJmPrimaryKeyConstraint();
            }
            for (JmColumn column : this.table.getColumns()) {
                if (!column.getName().equals(element.columnName)) continue;
                this.primaryKey.addKeyColumn(column.toReference());
                break;
            }
            this.table.store((JmConstraint)this.primaryKey);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ColumnMetaVisitor
    extends AbstractTypeSafeResultSetVisitor<ColumnMeta, List<JmColumn>, SQLException> {
        private final SimpleJmTable table;

        private ColumnMetaVisitor(SimpleJmTable table) {
            Validate.notNull((Object)table);
            this.table = table;
        }

        public List<JmColumn> visit(ColumnMeta element) {
            Validate.notNull((Object)element);
            SimpleJmColumn column = new SimpleJmColumn();
            column.setName(element.columnName);
            column.setDefaultValue(element.columnDef);
            RawTypeCategory category = RawTypeCategory.fromSqlType((int)element.dataType);
            SimpleRawTypeDescriptor typeRef = new SimpleRawTypeDescriptor(category, element.typeName, new String[0]);
            SimpleDataType dataType = new SimpleDataType((RawTypeDescriptor)typeRef);
            Map typeParameterSpecs = DefaultDbObjectImportVisitor.this.dialect.getTypeParameterSpecs((RawTypeDescriptor)typeRef);
            for (TypeParameterKey key : typeParameterSpecs.keySet()) {
                if (key.equals((Object)TypeParameterKey.SIZE)) {
                    dataType.putParam(TypeParameterKey.SIZE, (Object)element.columnSize);
                    continue;
                }
                if (key.equals((Object)TypeParameterKey.PRECISION)) {
                    dataType.putParam(TypeParameterKey.PRECISION, (Object)element.columnSize);
                    continue;
                }
                if (!key.equals((Object)TypeParameterKey.SCALE)) continue;
                dataType.putParam(TypeParameterKey.SCALE, (Object)element.decimalDigits);
            }
            column.setDataType((DataType)dataType);
            this.table.store((JmColumn)column);
            if (element.nullable == ColumnMeta.Nullable.NO_NULLS) {
                SimpleJmNotNullConstraint notNullConstraint = new SimpleJmNotNullConstraint();
                notNullConstraint.setColumn(column.toReference());
                this.table.store((JmConstraint)notNullConstraint);
            }
            ((List)this.finalResult).add(column);
            return null;
        }

        protected void init() {
            this.finalResult = Lists.newArrayList();
        }
    }
}

