/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.dddbase.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jiemamy.dddbase.Entity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CloneUtil {
    public static <E extends Entity> ArrayList<E> cloneEntityArrayList(Collection<E> collection) {
        ArrayList cloneCollection = Lists.newArrayListWithExpectedSize((int)collection.size());
        for (Entity element : collection) {
            Entity cloneElement = element.clone();
            cloneCollection.add(cloneElement);
        }
        return cloneCollection;
    }

    public static <K, V extends Entity> ConcurrentHashMap<K, V> cloneEntityConcurrentHashMap(Map<K, V> map) {
        ConcurrentHashMap<K, Entity> cloneMap = new ConcurrentHashMap<K, Entity>(map.size());
        for (Map.Entry<K, V> element : map.entrySet()) {
            Entity cloneValue = ((Entity)element.getValue()).clone();
            cloneMap.put(element.getKey(), cloneValue);
        }
        return cloneMap;
    }

    public static <K, V extends Entity> HashMap<K, V> cloneEntityHashMap(Map<K, V> map) {
        HashMap cloneMap = Maps.newHashMapWithExpectedSize((int)map.size());
        for (Map.Entry<K, V> element : map.entrySet()) {
            Entity cloneValue = ((Entity)element.getValue()).clone();
            cloneMap.put(element.getKey(), cloneValue);
        }
        return cloneMap;
    }

    public static <E extends Entity> HashSet<E> cloneEntityHashSet(Collection<E> collection) {
        HashSet cloneCollection = Sets.newHashSetWithExpectedSize((int)collection.size());
        for (Entity element : collection) {
            Entity cloneElement = element.clone();
            cloneCollection.add(cloneElement);
        }
        return cloneCollection;
    }

    public static <E extends Entity> LinkedHashSet<E> cloneEntityLinkedHashSet(Collection<E> collection) {
        LinkedHashSet cloneCollection = Sets.newLinkedHashSet();
        for (Entity element : collection) {
            Entity cloneElement = element.clone();
            cloneCollection.add(cloneElement);
        }
        return cloneCollection;
    }

    public static <E> ArrayList<E> cloneValueArrayList(Collection<E> collection) {
        return Lists.newArrayList(collection);
    }

    public static <K, V> HashMap<K, V> cloneValueHashMap(Map<K, V> map) {
        return Maps.newHashMap(map);
    }

    public static <E> HashSet<E> cloneValueHashSet(Collection<E> collection) {
        return Sets.newHashSet(collection);
    }

    public static <E> LinkedHashSet<E> cloneValueLinkedHashSet(Collection<E> collection) {
        return Sets.newLinkedHashSet(collection);
    }

    private CloneUtil() {
    }
}

