/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.lib.exception;

import org.seasar.framework.exception.SRuntimeException;

/**
 * 検索条件の値に<code>null</code>を渡したときの例外です。
 * 
 * @author azusa
 * 
 */
public class NullConditionValueException extends SRuntimeException {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;

    /**
     * コンストラクタです。
     * 
     * @param args
     *            置換するメッセージ
     */
    public NullConditionValueException(Object... args) {
        super("ECGL0001", args);
    }

}
