/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.lib.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.seasar.codegen.lib.BindValue;
import org.seasar.codegen.lib.Column;
import org.seasar.codegen.lib.ConditionResult;
import org.seasar.codegen.lib.Order;
import org.seasar.codegen.lib.Query;

/**
 * @author azusa
 * 
 */
public class ConditionResultImpl implements ConditionResult {

    private List<Order> orderList = new ArrayList<Order>();

    private List<BindValue> bindValues = new ArrayList<BindValue>();

    private Query query = new NullQuery();

    /*
     * (非 Javadoc)
     * 
     * @see
     * org.seasar.codegen.lib.ConditionResult#addOrder(org.seasar.codegen.lib
     * .Column, boolean)
     */
    public void addOrder(Column column, boolean asc) {
        orderList.add(new OrderImpl(column, asc));

    }

    /*
     * (非 Javadoc)
     * 
     * @see org.seasar.codegen.lib.ConditionResult#addQuery(java.lang.String,
     * java.lang.Object[])
     */
    public void addQuery(String query, Object... args) {
        this.query = new QueryImpl(query, args);
    }

    /*
     * (非 Javadoc)
     * 
     * @see org.seasar.codegen.lib.ConditionResult#getConditionValue()
     */
    public List<BindValue> getBindValues() {
        return bindValues;
    }

    /*
     * (非 Javadoc)
     * 
     * @see org.seasar.codegen.lib.ConditionResult#getOrderList()
     */
    public List<Order> getOrderList() {
        return orderList;
    }

    /*
     * (非 Javadoc)
     * 
     * @see org.seasar.codegen.lib.ConditionResult#getQuery()
     */
    public Query getQuery() {
        return query;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (BindValue bindValue : bindValues) {
            sb.append("/");
            sb.append(bindValue);
        }
        if (!orderList.isEmpty()) {
            sb.append("/ORDER BY ");
        }
        {
            Iterator<Order> i = orderList.iterator();
            while (i.hasNext()) {
                sb.append(i.next());
                if (i.hasNext()) {
                    sb.append(",");
                }
            }
        }
        return sb.toString();
    }

    /*
     * (非 Javadoc)
     * 
     * @see org.seasar.codegen.lib.ConditionResult#addBindValue()
     */
    public void addBindValue(BindValue bindValue) {
        bindValues.add(bindValue);
    }

    private static class NullQuery implements Query {

        private static final Object[] EMPTY = new Object[0];

        public Object[] getArgs() {
            return EMPTY;
        }

        public String getQuery() {
            return "";
        }

        @Override
        public String toString() {
            return "";
        }

    }
}
