/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.lib.impl;

import org.seasar.codegen.lib.BindValue;
import org.seasar.codegen.lib.Column;
import org.seasar.codegen.lib.Condition;
import org.seasar.codegen.lib.Operator;

/**
 * @author azusa
 * 
 */
public class BindValueImpl implements BindValue {

    /**
     * コンストラクタです。
     * 
     * @param column
     *            カラム
     * @param operator
     *            演算子
     * @param args
     *            バインド変数の配列
     */
    public BindValueImpl(Column column, Operator operator, Object[] args) {
        this.column = column;
        this.operator = operator;
        this.args = args;
    }

    /**
     * コンストラクタです。
     * 
     * @param args
     */
    public BindValueImpl(Object[] args) {
        column = NullColumn.INSTANCE;
        this.operator = Operator.EQUAL;
        this.args = args;
    }

    public Column getColumn() {
        return column;
    }

    public Operator getOperator() {
        return operator;
    }

    public Object[] getArgs() {
        return args;
    }

    private Column column;

    private Operator operator;

    private Object[] args;

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(column);
        sb.append(operator.getOperator());
        for (Object arg : args) {
            sb.append(arg);
        }
        return sb.toString();
    }

    private static class NullColumn implements Column {

        static Column INSTANCE = new NullColumn();

        /*
         * (非 Javadoc)
         * 
         * @see org.seasar.codegen.lib.Column#getAlias()
         */
        public String getAlias() {
            return "";
        }

        /*
         * (非 Javadoc)
         * 
         * @see org.seasar.codegen.lib.Column#getName()
         */
        public String getName() {
            return "";
        }

        @Override
        public String toString() {
            return "";
        }

        /*
         * (非 Javadoc)
         * 
         * @see org.seasar.codegen.lib.Column#getCodnitionClass()
         */
        public Class<? extends Condition> getCodnitionClass() {
            throw new UnsupportedOperationException();
        }

    }

}
