/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.aptina.beans.internal;

import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import org.seasar.aptina.beans.internal.BeanClassFormat;
import org.seasar.aptina.beans.internal.BeanInfo;
import org.seasar.aptina.beans.internal.ConstructorInfo;
import org.seasar.aptina.beans.internal.PropertyInfo;
import org.seasar.aptina.commons.source.SimpleSourceGenerator;
import org.seasar.aptina.commons.util.ClassUtils;
import org.seasar.aptina.commons.util.CollectionUtils;
import org.seasar.aptina.commons.util.ModifierUtils;
import org.seasar.aptina.commons.util.StringUtils;

public class BeanClassGenerator
extends SimpleSourceGenerator<BeanClassFormat> {
    public BeanClassGenerator(ProcessingEnvironment env) {
        super(env, BeanClassFormat.class);
    }

    public void generateAndWrite(BeanInfo beanInfo, TypeElement originalElement) throws IOException {
        this.generate(beanInfo, originalElement);
        this.write(ClassUtils.getQualifiedName((String)beanInfo.getPackageName(), (String)beanInfo.getBeanClassName()), originalElement);
    }

    public void generate(BeanInfo beanInfo, TypeElement originalElement) {
        this.reset();
        this.putClassHeader(beanInfo);
        this.putFields(beanInfo);
        for (ConstructorInfo constructorInfo : beanInfo.getConstructors()) {
            this.putConstructor(beanInfo, constructorInfo);
        }
        this.putEventListener(beanInfo);
        for (String propertyName : beanInfo.getPropertyNames()) {
            PropertyInfo propertyInfo = beanInfo.getPropertyInfo(propertyName);
            this.putGetter(beanInfo, propertyInfo);
            this.putSetter(beanInfo, propertyInfo);
            this.putSpecificEventListener(beanInfo, propertyInfo);
        }
        this.putClassFooter(beanInfo);
    }

    protected void putClassHeader(BeanInfo beanInfo) {
        String packageName = beanInfo.getPackageName();
        if (StringUtils.isNotEmpty((CharSequence)packageName)) {
            this.printf("package %1$s;%n%n", new Object[]{packageName});
        }
        this.printJavadoc(beanInfo.getComment());
        this.printf("@org.seasar.aptina.beans.JavaBean%n", new Object[0]);
        this.printGeneratedAnnotation("Aptina Beans", "org.seasar.aptina", "aptina-beans");
        this.printf("public class %1$s%2$s extends %3$s {%n", new Object[]{beanInfo.getBeanClassName(), beanInfo.getTypeParameter(), beanInfo.getStateClassName()});
        this.printf("%n", new Object[0]);
    }

    protected void putFields(BeanInfo beanInfo) {
        this.enter();
        if (beanInfo.isBoundProperties()) {
            this.printf("java.beans.PropertyChangeSupport propertyChangeSupport =%n", new Object[0]);
            this.printf("    new java.beans.PropertyChangeSupport(this);%n%n", new Object[0]);
        }
        if (beanInfo.isConstrainedProperties()) {
            this.printf("java.beans.VetoableChangeSupport vetoableChangeSupport =%n", new Object[0]);
            this.printf("    new java.beans.VetoableChangeSupport(this);%n%n", new Object[0]);
        }
        this.leave();
    }

    protected void putClassFooter(BeanInfo beanInfo) {
        this.printf("}%n", new Object[0]);
    }

    protected void putConstructor(BeanInfo beanInfo, ConstructorInfo constructorInfo) {
        String modifiers = ModifierUtils.toStringOfModifiers(constructorInfo.getModifiers());
        String typeParameters = constructorInfo.getTypeParameters();
        String className = beanInfo.getBeanClassName();
        String params = StringUtils.join(constructorInfo.getParameterTypes(), constructorInfo.getParameterNames(), (String)" ", (String)", ");
        String exceptions = constructorInfo.getThrownTypes().isEmpty() ? "" : " throws " + StringUtils.join(constructorInfo.getThrownTypes(), (String)", ");
        this.enter();
        this.printJavadoc(constructorInfo.getComment());
        this.printf("%1$s%2$s %3$s(%4$s)%5$s {%n", new Object[]{modifiers, typeParameters, className, params, exceptions});
        this.enter();
        this.printf("super(%1$s);%n", new Object[]{StringUtils.join(constructorInfo.getParameterNames(), (String)", ")});
        this.leave();
        this.printf("}%n%n", new Object[0]);
        this.leave();
    }

    protected void putGetter(BeanInfo beanInfo, PropertyInfo propertyInfo) {
        if (propertyInfo.isReadable()) {
            this.putNormalGetter(beanInfo, propertyInfo);
            if (propertyInfo.isArray()) {
                this.putIndexedGetter(beanInfo, propertyInfo);
            }
        }
    }

    protected void putNormalGetter(BeanInfo beanInfo, PropertyInfo propertyInfo) {
        String comment = propertyInfo.getComment();
        String type = propertyInfo.getType();
        String name = propertyInfo.getName();
        String capitalizedName = StringUtils.capitalize((String)name);
        this.enter();
        this.printJavadoc(BeanClassFormat.JDOC0000, new Object[]{comment});
        this.printf("public %1$s %2$s%3$s() {%n", new Object[]{type, type.equals("boolean") ? "is" : "get", capitalizedName});
        this.enter();
        this.printf("return %1$s;%n", new Object[]{name});
        this.leave();
        this.printf("}%n%n", new Object[0]);
        this.leave();
    }

    protected void putIndexedGetter(BeanInfo beanInfo, PropertyInfo propertyInfo) {
        String comment = propertyInfo.getComment();
        String type = propertyInfo.getType();
        String methodPrefix = type.equals("boolean") ? "is" : "get";
        String name = propertyInfo.getName();
        String capitalizedName = StringUtils.capitalize((String)name);
        String componentType = propertyInfo.getComponentType();
        this.enter();
        this.printJavadoc(BeanClassFormat.JDOC0001, new Object[]{comment});
        this.printf("public %1$s %2$s%3$s(int n) throws ArrayIndexOutOfBoundsException {%n", new Object[]{componentType, methodPrefix, capitalizedName});
        this.enter();
        this.printf("return %1$s[n];%n", new Object[]{name});
        this.leave();
        this.printf("}%n%n", new Object[0]);
        this.leave();
    }

    protected void putSetter(BeanInfo beanInfo, PropertyInfo propertyInfo) {
        if (propertyInfo.isWritable()) {
            this.putNormalSetter(beanInfo, propertyInfo);
            if (propertyInfo.isArray()) {
                this.putIndexedSetter(beanInfo, propertyInfo);
            }
        }
    }

    protected void putNormalSetter(BeanInfo beanInfo, PropertyInfo propertyInfo) {
        String comment = propertyInfo.getComment();
        String type = propertyInfo.getType();
        String name = propertyInfo.getName();
        String capitalizedName = StringUtils.capitalize((String)name);
        boolean bound = beanInfo.isBoundProperties();
        boolean constrained = beanInfo.isConstrainedProperties();
        String exceptions = constrained ? " throws java.beans.PropertyVetoException" : "";
        this.enter();
        this.printJavadoc(constrained ? BeanClassFormat.JDOC0004 : BeanClassFormat.JDOC0002, new Object[]{comment, name});
        this.printf("public void set%1$s(%2$s %3$s)%4$s {%n", new Object[]{capitalizedName, type, name, exceptions});
        this.enter();
        if (bound || constrained) {
            this.printf("%1$s old%2$s = this.%3$s;%n", new Object[]{type, capitalizedName, name});
        }
        if (constrained) {
            this.printf("vetoableChangeSupport.fireVetoableChange(\"%1$s\", old%2$s, %1$s);%n", new Object[]{name, capitalizedName});
        }
        this.printf("this.%1$s = %1$s;%n", new Object[]{name});
        if (bound) {
            this.printf("propertyChangeSupport.firePropertyChange(\"%1$s\", old%2$s, %1$s);%n", new Object[]{name, capitalizedName});
        }
        this.leave();
        this.printf("}%n%n", new Object[0]);
        this.leave();
    }

    protected void putIndexedSetter(BeanInfo beanInfo, PropertyInfo propertyInfo) {
        String comment = propertyInfo.getComment();
        String name = propertyInfo.getName();
        String capitalizedName = StringUtils.capitalize((String)name);
        String componentType = propertyInfo.getComponentType();
        boolean bound = beanInfo.isBoundProperties();
        boolean constrained = beanInfo.isConstrainedProperties();
        List exceptions = CollectionUtils.newArrayList();
        exceptions.add("ArrayIndexOutOfBoundsException");
        if (constrained) {
            exceptions.add("java.beans.PropertyVetoException");
        }
        this.enter();
        this.printJavadoc(constrained ? BeanClassFormat.JDOC0005 : BeanClassFormat.JDOC0003, new Object[]{comment, name});
        this.printf("public void set%1$s(int n, %2$s %3$s) throws %4$s {%n", new Object[]{capitalizedName, componentType, name, StringUtils.join((Iterable)exceptions, (String)", ")});
        this.enter();
        if (bound || constrained) {
            this.printf("%1$s old%2$s = this.%3$s[n];%n", new Object[]{componentType, capitalizedName, name});
        }
        if (constrained) {
            this.printf("vetoableChangeSupport.fireVetoableChange(new java.beans.IndexedPropertyChangeEvent(this, \"%1$s\", old%2$s, %1$s, n));%n", new Object[]{name, capitalizedName});
        }
        this.printf("this.%1$s[n] = %1$s;%n", new Object[]{name});
        if (bound) {
            this.printf("propertyChangeSupport.fireIndexedPropertyChange(\"%1$s\", n, old%2$s, %1$s);%n", new Object[]{name, capitalizedName});
        }
        this.leave();
        this.printf("}%n%n", new Object[0]);
        this.leave();
    }

    protected void putEventListener(BeanInfo beanInfo) {
        this.enter();
        if (beanInfo.isBoundProperties()) {
            this.printJavadoc(BeanClassFormat.JDOC0006, new Object[]{PropertyChangeListener.class.getName()});
            this.printf("public void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {%n", new Object[0]);
            this.enter();
            this.printf("propertyChangeSupport.addPropertyChangeListener(listener);%n", new Object[0]);
            this.leave();
            this.printf("}%n%n", new Object[0]);
            this.printJavadoc(BeanClassFormat.JDOC0007, new Object[]{PropertyChangeListener.class.getName()});
            this.printf("public void addPropertyChangeListener(String propertyName, java.beans.PropertyChangeListener listener) {%n", new Object[0]);
            this.enter();
            this.printf("propertyChangeSupport.addPropertyChangeListener(propertyName, listener);%n", new Object[0]);
            this.leave();
            this.printf("}%n%n", new Object[0]);
            this.printJavadoc(BeanClassFormat.JDOC0008, new Object[]{PropertyChangeListener.class.getName()});
            this.printf("public void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {%n", new Object[0]);
            this.enter();
            this.printf("propertyChangeSupport.removePropertyChangeListener(listener);%n", new Object[0]);
            this.leave();
            this.printf("}%n%n", new Object[0]);
            this.printJavadoc(BeanClassFormat.JDOC0009, new Object[]{PropertyChangeListener.class.getName()});
            this.printf("public void removePropertyChangeListener(String propertyName, java.beans.PropertyChangeListener listener) {%n", new Object[0]);
            this.enter();
            this.printf("propertyChangeSupport.removePropertyChangeListener(propertyName, listener);%n", new Object[0]);
            this.leave();
            this.printf("}%n%n", new Object[0]);
        }
        if (beanInfo.isConstrainedProperties()) {
            this.printJavadoc(BeanClassFormat.JDOC0006, new Object[]{VetoableChangeListener.class.getName()});
            this.printf("public void addVetoableChangeListener(java.beans.VetoableChangeListener listener) {%n", new Object[0]);
            this.enter();
            this.printf("vetoableChangeSupport.addVetoableChangeListener(listener);%n", new Object[0]);
            this.leave();
            this.printf("}%n%n", new Object[0]);
            this.printJavadoc(BeanClassFormat.JDOC0007, new Object[]{VetoableChangeListener.class.getName()});
            this.printf("public void addVetoableChangeListener(String propertyName, java.beans.VetoableChangeListener listener) {%n", new Object[0]);
            this.enter();
            this.printf("vetoableChangeSupport.addVetoableChangeListener(propertyName, listener);%n", new Object[0]);
            this.leave();
            this.printf("}%n%n", new Object[0]);
            this.printJavadoc(BeanClassFormat.JDOC0008, new Object[]{VetoableChangeListener.class.getName()});
            this.printf("public void removeVetoableChangeListener(java.beans.VetoableChangeListener listener) {%n", new Object[0]);
            this.enter();
            this.printf("vetoableChangeSupport.removeVetoableChangeListener(listener);%n", new Object[0]);
            this.leave();
            this.printf("}%n%n", new Object[0]);
            this.printJavadoc(BeanClassFormat.JDOC0009, new Object[]{VetoableChangeListener.class.getName()});
            this.printf("public void removeVetoableChangeListener(String propertyName, java.beans.VetoableChangeListener listener) {%n", new Object[0]);
            this.enter();
            this.printf("vetoableChangeSupport.removeVetoableChangeListener(propertyName, listener);%n", new Object[0]);
            this.leave();
            this.printf("}%n%n", new Object[0]);
        }
        this.leave();
    }

    protected void putSpecificEventListener(BeanInfo beanInfo, PropertyInfo propertyInfo) {
        if (!propertyInfo.isWritable()) {
            return;
        }
        String comment = propertyInfo.getComment();
        String name = propertyInfo.getName();
        String capitalizeName = StringUtils.capitalize((String)name);
        this.enter();
        if (beanInfo.isBoundProperties()) {
            this.printJavadoc(BeanClassFormat.JDOC0010, new Object[]{PropertyChangeListener.class.getName(), comment});
            this.printf("public void add%1$sChangeListener(java.beans.PropertyChangeListener listener) {%n", new Object[]{capitalizeName});
            this.enter();
            this.printf("propertyChangeSupport.addPropertyChangeListener(\"%1$s\", listener);%n", new Object[]{name});
            this.leave();
            this.printf("}%n%n", new Object[0]);
            this.printJavadoc(BeanClassFormat.JDOC0011, new Object[]{PropertyChangeListener.class.getName(), comment});
            this.printf("public void remove%1$sChangeListener(java.beans.PropertyChangeListener listener) {%n", new Object[]{capitalizeName});
            this.enter();
            this.printf("propertyChangeSupport.removePropertyChangeListener(\"%1$s\", listener);%n", new Object[]{name});
            this.leave();
            this.printf("}%n%n", new Object[0]);
        }
        if (beanInfo.isConstrainedProperties()) {
            this.printJavadoc(BeanClassFormat.JDOC0010, new Object[]{VetoableChangeListener.class.getName(), comment});
            this.printf("public void add%1$sChangeListener(java.beans.VetoableChangeListener listener) {%n", new Object[]{capitalizeName});
            this.enter();
            this.printf("vetoableChangeSupport.addVetoableChangeListener(\"%1$s\", listener);%n", new Object[]{name});
            this.leave();
            this.printf("}%n%n", new Object[0]);
            this.printJavadoc(BeanClassFormat.JDOC0011, new Object[]{VetoableChangeListener.class.getName(), comment});
            this.printf("public void remove%1$sChangeListener(java.beans.VetoableChangeListener listener) {%n", new Object[]{capitalizeName});
            this.enter();
            this.printf("vetoableChangeSupport.removeVetoableChangeListener(\"%1$s\", listener);%n", new Object[]{name});
            this.leave();
            this.printf("}%n%n", new Object[0]);
        }
        this.leave();
    }
}

