/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.aptina.commons.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.seasar.aptina.commons.util.AssertionUtils;
import org.seasar.aptina.commons.util.ClassUtils;
import org.seasar.aptina.commons.util.CollectionUtils;
import org.seasar.aptina.commons.util.StringUtils;
import org.seasar.aptina.commons.util.TypeMirrorUtils;

public class ElementUtils {
    private ElementUtils() {
    }

    public static TypeElement getTypeElement(Elements elementUtils, Class<?> clazz) {
        AssertionUtils.assertNotNull("elements", elementUtils);
        AssertionUtils.assertNotNull("clazz", clazz);
        return ElementUtils.getTypeElement(elementUtils, clazz.getName());
    }

    public static TypeElement getTypeElement(Elements elementUtils, String className) {
        AssertionUtils.assertNotEmpty("className", className);
        try {
            return elementUtils.getTypeElement(className);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static VariableElement getFieldElement(TypeElement typeElement, Field field) {
        AssertionUtils.assertNotNull("typeElement", typeElement);
        AssertionUtils.assertNotNull("field", field);
        return ElementUtils.getFieldElement(typeElement, field.getName());
    }

    public static VariableElement getFieldElement(TypeElement typeElement, String fieldName) {
        AssertionUtils.assertNotNull("typeElement", typeElement);
        AssertionUtils.assertNotEmpty("fieldName", fieldName);
        for (VariableElement variableElement : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
            if (!fieldName.equals(variableElement.getSimpleName().toString())) continue;
            return variableElement;
        }
        return null;
    }

    public static ExecutableElement getConstructorElement(TypeElement typeElement) {
        AssertionUtils.assertNotNull("typeElement", typeElement);
        for (ExecutableElement executableElement : ElementFilter.constructorsIn(typeElement.getEnclosedElements())) {
            if (executableElement.getParameters().size() != 0) continue;
            return executableElement;
        }
        return null;
    }

    public static ExecutableElement getConstructorElement(TypeElement typeElement, Class<?> ... parameterTypes) {
        AssertionUtils.assertNotNull("typeElement", typeElement);
        AssertionUtils.assertNotNull("parameterTypes", parameterTypes);
        for (ExecutableElement executableElement : ElementFilter.constructorsIn(typeElement.getEnclosedElements())) {
            if (!ElementUtils.isSameTypes(parameterTypes, executableElement.getParameters())) continue;
            return executableElement;
        }
        return null;
    }

    public static ExecutableElement getConstructorElement(TypeElement typeElement, String ... parameterTypeNames) {
        AssertionUtils.assertNotNull("typeElement", typeElement);
        AssertionUtils.assertNotNull("parameterTypeNames", parameterTypeNames);
        for (ExecutableElement executableElement : ElementFilter.constructorsIn(typeElement.getEnclosedElements())) {
            if (!ElementUtils.isSameTypes(parameterTypeNames, executableElement.getParameters())) continue;
            return executableElement;
        }
        return null;
    }

    public static ExecutableElement getMethodElement(TypeElement typeElement, String methodName) {
        AssertionUtils.assertNotNull("typeElement", typeElement);
        AssertionUtils.assertNotEmpty("methodName", methodName);
        for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
            if (!methodName.equals(executableElement.getSimpleName().toString()) || executableElement.getParameters().size() != 0) continue;
            return executableElement;
        }
        return null;
    }

    public static ExecutableElement getMethodElement(TypeElement typeElement, String methodName, Class<?> ... parameterTypes) {
        AssertionUtils.assertNotNull("typeElement", typeElement);
        AssertionUtils.assertNotEmpty("methodName", methodName);
        AssertionUtils.assertNotNull("parameterTypes", parameterTypes);
        for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
            if (!methodName.equals(executableElement.getSimpleName().toString()) || !ElementUtils.isSameTypes(parameterTypes, executableElement.getParameters())) continue;
            return executableElement;
        }
        return null;
    }

    public static ExecutableElement getMethodElement(TypeElement typeElement, String methodName, String ... parameterTypeNames) {
        AssertionUtils.assertNotNull("typeElement", typeElement);
        AssertionUtils.assertNotEmpty("methodName", methodName);
        AssertionUtils.assertNotNull("parameterTypeNames", parameterTypeNames);
        for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
            if (!methodName.equals(executableElement.getSimpleName().toString()) || !ElementUtils.isSameTypes(parameterTypeNames, executableElement.getParameters())) continue;
            return executableElement;
        }
        return null;
    }

    public static AnnotationMirror getAnnotationMirror(Element element, Class<? extends Annotation> annotationClass) {
        return ElementUtils.getAnnotationMirror(element, annotationClass.getName());
    }

    public static AnnotationMirror getAnnotationMirror(Element element, String annotationClassName) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            if (!annotationType.toString().equals(annotationClassName)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static boolean isSameTypes(Class<?>[] parameterTypes, List<? extends VariableElement> variableElements) {
        AssertionUtils.assertNotNull("parameterTypes", parameterTypes);
        AssertionUtils.assertNotNull("variableElements", variableElements);
        return ElementUtils.isSameTypes(ClassUtils.getQualifiedNameArray(parameterTypes), variableElements);
    }

    public static boolean isSameTypes(String[] typeNames, List<? extends VariableElement> variableElements) {
        AssertionUtils.assertNotNull("typeNames", typeNames);
        AssertionUtils.assertNotNull("variableElements", variableElements);
        if (typeNames.length != variableElements.size()) {
            return false;
        }
        for (int i = 0; i < typeNames.length; ++i) {
            if (typeNames[i].equals(variableElements.get(i).asType().toString())) continue;
            return false;
        }
        return true;
    }

    public static List<String> toSimpleNameList(List<? extends Element> elements) {
        List<String> result = CollectionUtils.newArrayList();
        for (Element element : elements) {
            result.add(element.getSimpleName().toString());
        }
        return result;
    }

    public static String toStringOfTypeParameterDecl(List<? extends TypeParameterElement> typeParameters) {
        if (typeParameters.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder(64);
        String parameterPrefix = "<";
        for (TypeParameterElement typeParameterElement : typeParameters) {
            List<? extends TypeMirror> bounds = typeParameterElement.getBounds();
            buf.append(parameterPrefix).append(typeParameterElement.getSimpleName());
            if (bounds.size() > 1 || bounds.get(0).toString() == "java.lang.Object") {
                buf.append(" extends ").append(StringUtils.join(TypeMirrorUtils.toTypeNameList(bounds), " & "));
            }
            parameterPrefix = ", ";
        }
        buf.append('>');
        return new String(buf);
    }

    public static String toStringOfTypeParameterNames(List<? extends TypeParameterElement> typeParameters) {
        if (typeParameters.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder(64);
        buf.append("<").append(StringUtils.join(ElementUtils.toSimpleNameList(typeParameters), ", ")).append(">");
        return new String(buf);
    }
}

