/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.struts.upload;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.upload.CommonsMultipartRequestHandler;
import org.apache.struts.upload.FormFile;
import org.apache.struts.upload.MultipartRequestWrapper;

public class S2MultipartRequestHandler
extends CommonsMultipartRequestHandler {
    public static final String SIZE_EXCEPTION_KEY = S2MultipartRequestHandler.class.getName() + ".EXCEPTION";
    protected Hashtable elementsAll;
    protected Hashtable elementsFile;
    protected Hashtable elementsText;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(HttpServletRequest request) throws ServletException {
        ModuleConfig ac = (ModuleConfig)request.getAttribute("org.apache.struts.action.MODULE");
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory((int)this.getSizeThreshold(ac), new File(this.getRepositoryPath(ac))));
        upload.setHeaderEncoding(request.getCharacterEncoding());
        upload.setSizeMax(this.getSizeMax(ac));
        this.elementsText = new Hashtable();
        this.elementsFile = new Hashtable();
        this.elementsAll = new Hashtable();
        List items = null;
        try {
            items = upload.parseRequest(request);
        }
        catch (FileUploadBase.SizeLimitExceededException e) {
            request.setAttribute("org.apache.struts.upload.MaxLengthExceeded", (Object)Boolean.TRUE);
            request.setAttribute(SIZE_EXCEPTION_KEY, (Object)e);
            try {
                ServletInputStream is = request.getInputStream();
                try {
                    byte[] buf = new byte[1024];
                    int len = 0;
                    while ((len = is.read(buf)) != -1) {
                    }
                }
                catch (Exception ignore) {
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (Exception ignore) {}
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
            return;
        }
        catch (FileUploadException e) {
            log.error((Object)"Failed to parse multipart request", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        for (FileItem item : items) {
            if (item.isFormField()) {
                this.addTextParameter(request, item);
                continue;
            }
            this.addFileParameter(item);
        }
    }

    public Hashtable getTextElements() {
        return this.elementsText;
    }

    public Hashtable getFileElements() {
        return this.elementsFile;
    }

    public Hashtable getAllElements() {
        return this.elementsAll;
    }

    public void rollback() {
        for (FormFile formFile : this.elementsFile.values()) {
            formFile.destroy();
        }
    }

    protected void addTextParameter(HttpServletRequest request, FileItem item) {
        String[] newArray;
        String[] oldArray;
        String name = item.getFieldName();
        String value = null;
        boolean haveValue = false;
        String encoding = request.getCharacterEncoding();
        if (encoding != null) {
            try {
                value = item.getString(encoding);
                haveValue = true;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!haveValue) {
            try {
                value = item.getString("ISO-8859-1");
            }
            catch (UnsupportedEncodingException uee) {
                value = item.getString();
            }
            haveValue = true;
        }
        if (request instanceof MultipartRequestWrapper) {
            MultipartRequestWrapper wrapper = (MultipartRequestWrapper)request;
            wrapper.setParameter(name, value);
        }
        if ((oldArray = (String[])this.elementsText.get(name)) != null) {
            newArray = new String[oldArray.length + 1];
            System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
            newArray[oldArray.length] = value;
        } else {
            newArray = new String[]{value};
        }
        this.elementsText.put(name, newArray);
        this.elementsAll.put(name, newArray);
    }

    protected void addFileParameter(FileItem item) {
        S2FormFile formFile = new S2FormFile(item);
        this.elementsFile.put(item.getFieldName(), formFile);
        this.elementsAll.put(item.getFieldName(), formFile);
    }

    protected static class S2FormFile
    implements FormFile,
    Serializable {
        private static final long serialVersionUID = 1L;
        FileItem fileItem;

        public S2FormFile(FileItem fileItem) {
            this.fileItem = fileItem;
        }

        public String getContentType() {
            return this.fileItem.getContentType();
        }

        public void setContentType(String contentType) {
            throw new UnsupportedOperationException("The setContentType() method is not supported.");
        }

        public int getFileSize() {
            return (int)this.fileItem.getSize();
        }

        public void setFileSize(int filesize) {
            throw new UnsupportedOperationException("The setFileSize() method is not supported.");
        }

        public String getFileName() {
            return this.getBaseFileName(this.fileItem.getName());
        }

        public void setFileName(String fileName) {
            throw new UnsupportedOperationException("The setFileName() method is not supported.");
        }

        public byte[] getFileData() throws FileNotFoundException, IOException {
            return this.fileItem.get();
        }

        public InputStream getInputStream() throws FileNotFoundException, IOException {
            return this.fileItem.getInputStream();
        }

        public void destroy() {
            this.fileItem.delete();
        }

        protected String getBaseFileName(String filePath) {
            String fileName = new File(filePath).getName();
            int colonIndex = fileName.indexOf(":");
            if (colonIndex == -1) {
                colonIndex = fileName.indexOf("\\\\");
            }
            int backslashIndex = fileName.lastIndexOf("\\");
            if (colonIndex > -1 && backslashIndex > -1) {
                fileName = fileName.substring(backslashIndex + 1);
            }
            return fileName;
        }

        public String toString() {
            return this.getFileName();
        }
    }
}

