/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.flex2.core.format.amf3.type.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.seasar.flex2.core.format.amf.io.reader.AmfDataReader;
import org.seasar.flex2.core.format.amf3.io.reader.factory.Amf3DataReaderFactory;
import org.seasar.flex2.core.format.amf3.io.writer.Amf3DataWriter;
import org.seasar.flex2.core.format.amf3.io.writer.factory.Amf3DataWriterFactory;
import org.seasar.flex2.core.format.amf3.type.ByteArray;
import org.seasar.flex2.core.format.amf3.type.exception.FailedCompressRuntimeException;
import org.seasar.flex2.core.format.amf3.type.exception.FailedUnCompressRuntimeException;

public class ByteArrayImpl
extends ByteArrayInputStream
implements ByteArray {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final int FLATEING_BUFFER_SIZE = 8192;
    private DataInputStream dataInputStream;
    private DataOutputStream dataOutputStream;
    private Amf3DataReaderFactory dataReaderFactory;
    private Amf3DataWriterFactory dataWriterFactory;
    private ByteArrayOutputStream outputStream;

    public ByteArrayImpl() {
        super(EMPTY_BYTES);
        this.initializeSreams();
    }

    public void compress() {
        Deflater deflater = new Deflater(-1);
        deflater.setStrategy(0);
        deflater.setInput(this.buf);
        deflater.finish();
        byte[] deflatingBuffer = new byte[8192];
        this.outputStream.reset();
        try {
            while (!deflater.needsInput()) {
                deflater.deflate(deflatingBuffer);
                this.outputStream.write(deflatingBuffer);
            }
        }
        catch (Throwable t) {
            throw new FailedCompressRuntimeException(t);
        }
        finally {
            if (this.outputStream.size() > 0) {
                byte[] inflatedBytes = new byte[deflater.getTotalOut()];
                System.arraycopy(this.outputStream.toByteArray(), 0, inflatedBytes, 0, inflatedBytes.length);
                this.initBuffer(inflatedBytes);
            }
            deflater.end();
        }
    }

    public void flush() {
        this.initBuffer(this.mergaBuffers());
        this.outputStream.reset();
        this.pos = this.count;
    }

    public byte[] getBufferBytes() {
        byte[] buffer = new byte[this.count];
        System.arraycopy(this.buf, 0, buffer, 0, this.count);
        return buffer;
    }

    public void initBuffer(byte[] bytes) {
        if (bytes == null) {
            bytes = EMPTY_BYTES;
        }
        this.buf = bytes;
        this.pos = 0;
        this.count = this.buf.length;
    }

    public boolean readBoolean() throws IOException {
        return this.dataInputStream.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.dataInputStream.readByte();
    }

    public void readBytes(byte[] bytes, int offset, int length) throws IOException {
        this.dataInputStream.readFully(bytes, offset, length);
    }

    public char readChar() throws IOException {
        return this.dataInputStream.readChar();
    }

    public double readDouble() throws IOException {
        return this.dataInputStream.readDouble();
    }

    public float readFloat() throws IOException {
        return this.dataInputStream.readFloat();
    }

    public void readFully(byte[] b) throws IOException {
        this.dataInputStream.readFully(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.dataInputStream.readFully(b, off, len);
    }

    public int readInt() throws IOException {
        return this.dataInputStream.readInt();
    }

    public String readLine() throws IOException {
        return null;
    }

    public long readLong() throws IOException {
        return this.dataInputStream.readLong();
    }

    public String readMultiByte(int length, String charSet) throws IOException {
        byte[] charBytes = new byte[length];
        this.read(charBytes, 0, length);
        return new String(charBytes, charSet);
    }

    public Object readObject() throws IOException, ClassNotFoundException {
        byte dataType = this.dataInputStream.readByte();
        AmfDataReader reader = this.dataReaderFactory.createAmf3DataReader(dataType);
        return reader.read(this.dataInputStream);
    }

    public short readShort() throws IOException {
        return this.dataInputStream.readShort();
    }

    public int readUnsignedByte() throws IOException {
        return this.dataInputStream.readUnsignedByte();
    }

    public int readUnsignedShort() throws IOException {
        return this.dataInputStream.readUnsignedShort();
    }

    public String readUTF() throws IOException {
        return this.dataInputStream.readUTF();
    }

    public String readUTFBytes(int length) throws IOException {
        return this.readMultiByte(length, "UTF-8");
    }

    public void setDataReaderFactory(Amf3DataReaderFactory dataReaderFactory) {
        this.dataReaderFactory = dataReaderFactory;
    }

    public void setDataWriterFactory(Amf3DataWriterFactory dataWriterFactory) {
        this.dataWriterFactory = dataWriterFactory;
    }

    public int skipBytes(int n) throws IOException {
        return this.dataInputStream.skipBytes(n);
    }

    public void uncompress() {
        Inflater inflater = new Inflater(false);
        inflater.setInput(this.buf);
        byte[] inflatingBuffer = new byte[8192];
        this.outputStream.reset();
        try {
            while (!inflater.needsInput()) {
                inflater.inflate(inflatingBuffer);
                this.outputStream.write(inflatingBuffer);
            }
        }
        catch (Throwable t) {
            throw new FailedUnCompressRuntimeException(t);
        }
        finally {
            if (this.outputStream.size() > 0) {
                byte[] inflatedBytes = new byte[inflater.getTotalOut()];
                System.arraycopy(this.outputStream.toByteArray(), 0, inflatedBytes, 0, inflatedBytes.length);
                this.initBuffer(inflatedBytes);
            }
            inflater.end();
        }
    }

    public void write(byte[] b) throws IOException {
        this.dataOutputStream.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.dataOutputStream.write(b, off, len);
    }

    public void write(int b) throws IOException {
        this.dataOutputStream.write(b);
    }

    public void writeBoolean(boolean value) throws IOException {
        this.dataOutputStream.writeBoolean(value);
    }

    public void writeByte(int value) throws IOException {
        this.dataOutputStream.writeByte(value);
    }

    public void writeBytes(byte[] bytes, int offset, int length) throws IOException {
        this.dataOutputStream.write(bytes, offset, length);
    }

    public void writeBytes(String s) throws IOException {
        this.dataOutputStream.writeBytes(s);
    }

    public void writeChar(int v) throws IOException {
        this.dataOutputStream.writeChar(v);
    }

    public void writeChars(String s) throws IOException {
        this.dataOutputStream.writeChars(s);
    }

    public void writeDouble(double value) throws IOException {
        this.dataOutputStream.writeDouble(value);
    }

    public void writeFloat(float value) throws IOException {
        this.dataOutputStream.writeFloat(value);
    }

    public void writeInt(int value) throws IOException {
        this.dataOutputStream.writeInt(value);
    }

    public void writeLong(long v) throws IOException {
        this.dataOutputStream.writeLong(v);
    }

    public void writeMultiByte(String value, String charSet) throws IOException {
        byte[] charBytes = value.getBytes(charSet);
        this.writeBytes(charBytes, 0, charBytes.length);
    }

    public void writeObject(Object object) throws IOException {
        Amf3DataWriter writer = this.dataWriterFactory.createAmf3DataWriter(object);
        writer.writeAmf3Data(object, this.dataOutputStream);
    }

    public void writeShort(int value) throws IOException {
        this.dataOutputStream.writeShort(value);
    }

    public void writeUnsignedInt(int value) throws IOException {
        this.writeInt(value & Short.MAX_VALUE);
    }

    public void writeUTF(String value) throws IOException {
        this.dataOutputStream.writeUTF(value);
    }

    public void writeUTFBytes(String value) throws IOException {
        this.writeMultiByte(value, "UTF-8");
    }

    private final void initializeSreams() {
        this.outputStream = new ByteArrayOutputStream();
        this.dataInputStream = new DataInputStream(this);
        this.dataOutputStream = new DataOutputStream(this.outputStream);
    }

    private final byte[] mergaBuffers() {
        byte[] writeBytes = this.outputStream.toByteArray();
        byte[] newInitBytes = new byte[this.pos + writeBytes.length];
        System.arraycopy(this.buf, 0, newInitBytes, 0, this.pos);
        System.arraycopy(writeBytes, 0, newInitBytes, this.pos, writeBytes.length);
        return newInitBytes;
    }
}

