/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.flex2.rpc.remoting;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.flex2.rpc.remoting.processor.RemotingMessageProcessor;
import org.seasar.flex2.util.type.BooleanUtil;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.log.Logger;

public class RemotingGateway
extends HttpServlet {
    private static final long serialVersionUID = -5142496558861670626L;
    protected static final String version = "1.1.1-RC";
    protected static final Logger logger = Logger.getLogger((Class)RemotingGateway.class);
    private static final String GATEWAY_VERSION = "gatewayVersion";
    private static final String PARAMETER_SHOW_GET_RESPONSE = "showGetResponse";
    private static final String PARAMETER_USE_SESSION = "useSession";
    protected RemotingMessageProcessor processor;
    private String gatewayVersion;
    private String gatewayVersionMessage;
    private boolean isShowGetResponse;
    private boolean isUseSession;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.showGetResponse(response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.decisionSessionMode(request);
        response.setContentType("application/x-amf");
        this.processor.process(request, response);
    }

    public void init() throws ServletException {
        S2Container container = SingletonS2ContainerFactory.getContainer().getRoot();
        this.processor = (RemotingMessageProcessor)container.getComponent((Object)RemotingMessageProcessor.class);
        this.initGatewayVersionMessage();
        logger.info((Object)this.gatewayVersionMessage);
    }

    private final void decisionSessionMode(HttpServletRequest request) {
        if (this.isUseSession && request.isRequestedSessionIdValid()) {
            request.getSession(true);
        }
    }

    private final String getGatewayVersionParameter(String name) {
        String value = this.getInitParameter(name);
        return (value != null ? value : version) + " ";
    }

    private final boolean getInitParameterAsBoolean(String name) {
        return BooleanUtil.toBoolean(this.getInitParameter(name));
    }

    private final void initGatewayVersionMessage() {
        this.isShowGetResponse = this.getInitParameterAsBoolean(PARAMETER_SHOW_GET_RESPONSE);
        this.isUseSession = this.getInitParameterAsBoolean(PARAMETER_USE_SESSION);
        this.gatewayVersion = this.getGatewayVersionParameter(GATEWAY_VERSION);
        this.gatewayVersionMessage = "RemotingGateway " + this.gatewayVersion + "is running ...";
    }

    private final void showGetResponse(HttpServletResponse response) throws IOException {
        if (this.isShowGetResponse) {
            response.getWriter().write(this.gatewayVersionMessage);
        }
    }
}

