/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.flex2.rpc.remoting.message.processor.impl;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.seasar.flex2.rpc.remoting.message.data.Message;
import org.seasar.flex2.rpc.remoting.message.io.reader.MessageReader;
import org.seasar.flex2.rpc.remoting.message.io.reader.factory.MessageReaderFactory;
import org.seasar.flex2.rpc.remoting.message.io.writer.MessageWriter;
import org.seasar.flex2.rpc.remoting.message.io.writer.factory.MessageWriterFactory;
import org.seasar.flex2.rpc.remoting.message.processor.MessageBodyProcessor;
import org.seasar.flex2.rpc.remoting.message.processor.MessageHeaderProcessor;
import org.seasar.flex2.rpc.remoting.message.processor.MessageProcessor;

public class MessageProcessorImpl
implements MessageProcessor {
    private static final int MESSAGE_WRITING_BUFFER_SIZE = 4096;
    private MessageBodyProcessor bodyProcessor;
    private MessageHeaderProcessor headerProcessor;
    private MessageReaderFactory readerFactory;
    private MessageWriterFactory writerFactory;

    public MessageBodyProcessor getBodyProcessor() {
        return this.bodyProcessor;
    }

    public MessageHeaderProcessor getHeaderProcessor() {
        return this.headerProcessor;
    }

    public MessageReaderFactory getReaderFactory() {
        return this.readerFactory;
    }

    public MessageWriterFactory getWriterFactory() {
        return this.writerFactory;
    }

    public void process(DataInputStream inputStream, DataOutputStream outputStream) throws IOException {
        Message requestMessage = this.requestReadProcess(inputStream);
        Message responseMessage = this.requestProcess(requestMessage);
        this.responseWriteProcess(responseMessage, outputStream);
    }

    public Message requestProcess(Message requestMessage) {
        this.headerProcessor.processRequest(requestMessage);
        Message responseMessage = this.bodyProcessor.process(requestMessage);
        this.headerProcessor.processResponse(responseMessage);
        return responseMessage;
    }

    public void setBodyProcessor(MessageBodyProcessor bodyProcessor) {
        this.bodyProcessor = bodyProcessor;
    }

    public void setHeaderProcessor(MessageHeaderProcessor headerProcessor) {
        this.headerProcessor = headerProcessor;
    }

    public void setReaderFactory(MessageReaderFactory readerFactory) {
        this.readerFactory = readerFactory;
    }

    public void setWriterFactory(MessageWriterFactory writerFactory) {
        this.writerFactory = writerFactory;
    }

    private final Message requestReadProcess(DataInputStream inputStream) throws IOException {
        MessageReader messageReader = this.readerFactory.createMessageReader(inputStream);
        return messageReader.read();
    }

    private final void responseMessageWriteProcess(Message responseMessage, ByteArrayOutputStream messageByteArrayOutputStream) throws IOException {
        DataOutputStream messageDataOutputStream = new DataOutputStream(messageByteArrayOutputStream);
        MessageWriter messageWriter = this.writerFactory.createMessageWriter(messageDataOutputStream, responseMessage);
        messageWriter.write();
    }

    private final void responseWriteProcess(Message responseMessage, OutputStream responseOutputStream) throws IOException {
        ByteArrayOutputStream messageByteArrayOutputStream = new ByteArrayOutputStream(4096);
        this.responseMessageWriteProcess(responseMessage, messageByteArrayOutputStream);
        messageByteArrayOutputStream.writeTo(responseOutputStream);
        responseOutputStream.flush();
    }
}

