/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.flex2.util.data.transfer.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.seasar.flex2.util.data.storage.Storage;
import org.seasar.flex2.util.data.transfer.Transfer;
import org.seasar.flex2.util.data.transfer.annotation.factory.AnnotationHandlerFactory;
import org.seasar.flex2.util.data.transfer.annotation.handler.AnnotationHandler;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;

public class TransferImpl
implements Transfer {
    private static final AnnotationHandler annotationHandler = AnnotationHandlerFactory.getAnnotationHandler();

    private static final boolean isTransferTarget(Storage storage, String type) {
        return type != null && storage.getName().equalsIgnoreCase(type);
    }

    public void exportToStorage(Object target, Storage storage) {
        Class<?> resultClass = target.getClass();
        if (resultClass.isArray()) {
            Object[] resultArray = (Object[])target;
            for (int index = 0; index < resultArray.length; ++index) {
                this.processExportTo(resultArray[index], storage);
            }
        } else if (resultClass.isAssignableFrom(Map.class)) {
            Collection values = ((Map)target).values();
            Iterator ite = values.iterator();
            while (ite.hasNext()) {
                this.processExportTo(ite.next(), storage);
            }
        } else {
            this.processExportTo(target, storage);
        }
    }

    private void processExportTo(Object target, Storage storage) {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(target.getClass());
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            String type;
            PropertyDesc propertyDesc = beanDesc.getPropertyDesc(i);
            if (!propertyDesc.isReadable() && !propertyDesc.hasReadMethod() || !TransferImpl.isTransferTarget(storage, type = annotationHandler.getExportStorageType(beanDesc, propertyDesc))) continue;
            storage.setProperty(propertyDesc.getPropertyName(), propertyDesc.getValue(target));
        }
    }

    public void importToComponent(Storage storage, Object target) {
        Class<?> resultClass = target.getClass();
        if (resultClass.isArray()) {
            Object[] resultArray = (Object[])target;
            for (int index = 0; index < resultArray.length; ++index) {
                this.processImport(storage, resultArray[index]);
            }
        } else if (resultClass.isAssignableFrom(Map.class)) {
            Collection values = ((Map)target).values();
            Iterator ite = values.iterator();
            while (ite.hasNext()) {
                this.processImport(storage, ite.next());
            }
        } else {
            this.processImport(storage, target);
        }
    }

    private void processImport(Storage storage, Object target) {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(target.getClass());
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            String type;
            PropertyDesc propertyDesc = beanDesc.getPropertyDesc(i);
            if (!propertyDesc.isWritable() && !propertyDesc.hasWriteMethod() || !TransferImpl.isTransferTarget(storage, type = annotationHandler.getImportStorageType(beanDesc, propertyDesc))) continue;
            propertyDesc.setValue(target, storage.getProperty(propertyDesc.getPropertyName()));
        }
    }
}

