/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.flex2.core.format.amf3.io.writer.impl;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.seasar.flex2.core.format.amf3.io.writer.Amf3DataWriter;
import org.seasar.flex2.core.format.amf3.io.writer.impl.Amf3IntWriterImpl;

public abstract class AbstractAmf3UTF8StringWriterImpl
extends Amf3IntWriterImpl
implements Amf3DataWriter {
    private static final byte[] getUTF8StringBytes(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new byte[0];
        }
    }

    protected static final void writeUTF8String(String value, DataOutputStream outputStream) throws IOException {
        byte[] stringBytes = AbstractAmf3UTF8StringWriterImpl.getUTF8StringBytes(value);
        int stringDef = stringBytes.length << 1 | 1;
        AbstractAmf3UTF8StringWriterImpl.writeIntData(stringDef, outputStream);
        if (stringBytes.length > 0) {
            outputStream.write(stringBytes, 0, stringBytes.length);
        }
    }
}

