/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.flex2.core.format.amf3.io.reader.impl;

import java.io.DataInputStream;
import java.io.Externalizable;
import java.io.IOException;
import org.seasar.flex2.core.format.amf3.io.reader.ASObjectReader;
import org.seasar.flex2.core.format.amf3.io.reader.Amf3DataReader;
import org.seasar.flex2.core.format.amf3.io.reader.ExternalObjectReader;
import org.seasar.flex2.core.format.amf3.io.reader.TypedObjectReader;
import org.seasar.flex2.core.format.amf3.io.reader.impl.AbstractAmf3TypedObjectReaderImpl;
import org.seasar.flex2.core.format.amf3.type.Amf3Object;
import org.seasar.framework.util.ClassUtil;

public class Amf3ObjectReaderImpl
extends AbstractAmf3TypedObjectReaderImpl
implements Amf3DataReader {
    private ASObjectReader asobjectReader;
    private TypedObjectReader classTypedObjectReader;
    private ExternalObjectReader externalObjectReader;

    public Object read(DataInputStream inputStream) throws IOException {
        return this.readObject(inputStream);
    }

    public void setAsobjectReader(ASObjectReader asobjectReader) {
        this.asobjectReader = asobjectReader;
    }

    public void setClassTypedObjectReader(TypedObjectReader classTypedObjectReader) {
        this.classTypedObjectReader = classTypedObjectReader;
    }

    public void setExternalObjectReader(ExternalObjectReader externalObjectReader) {
        this.externalObjectReader = externalObjectReader;
    }

    private final Object readInlineClassObjectData(int objectDef, DataInputStream inputStream) throws IOException {
        Object object = null;
        String className = (String)this.amf3StringReader.read(inputStream);
        switch (objectDef & 0xC) {
            case 0: {
                Class clazz = ClassUtil.forName((String)className);
                this.addClassReference(clazz);
                object = this.classTypedObjectReader.read(objectDef, clazz, inputStream);
                break;
            }
            case 4: {
                Class clazz = ClassUtil.forName((String)className);
                if (Externalizable.class.isAssignableFrom(clazz)) {
                    this.addClassReference(clazz);
                    object = this.externalObjectReader.read(clazz, inputStream);
                    break;
                }
                throw new RuntimeException("Unsupport class type.class is [" + clazz + "].");
            }
            case 8: {
                this.addClassReference(Amf3Object.class);
                object = this.asobjectReader.read(inputStream);
                break;
            }
            case 12: {
                throw new RuntimeException("Unsupport encoding.objectDef is [" + objectDef + "].");
            }
            default: {
                throw new RuntimeException("unknown object encoding. objectDef is [" + objectDef + "].");
            }
        }
        return object;
    }

    private final Object readObjectData(int objectDef, DataInputStream inputStream) throws IOException {
        Object object = null;
        switch (objectDef & 2) {
            case 0: {
                object = this.readReferenceClassObjectData(objectDef, inputStream, this.getClassAt(objectDef >>> 2));
                break;
            }
            case 2: {
                object = this.readInlineClassObjectData(objectDef, inputStream);
                break;
            }
        }
        return object;
    }

    private final Object readReferenceClassObjectData(int objectDef, DataInputStream inputStream, Class clazz) throws IOException {
        Object object = null;
        object = clazz == Amf3Object.class ? this.asobjectReader.read(inputStream) : (Externalizable.class.isAssignableFrom(clazz) ? this.externalObjectReader.read(clazz, inputStream) : this.classTypedObjectReader.read(objectDef, clazz, inputStream));
        return object;
    }

    protected final Object readInlinedObject(int reference, DataInputStream inputStream) throws IOException {
        return this.readObjectData(reference, inputStream);
    }

    protected final Object readReferencedObject(int reference, DataInputStream inputStream) throws IOException {
        return this.getObjectAt(reference >>> 1);
    }
}

