/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.flex2.core.format.amf0.io.writer.impl;

import java.io.DataOutputStream;
import java.io.IOException;
import org.seasar.flex2.core.format.amf0.io.writer.Amf0DataWriter;
import org.seasar.flex2.core.format.amf0.io.writer.factory.Amf0DataWriterFactory;
import org.seasar.flex2.core.format.amf0.type.Amf0SharedObject;
import org.seasar.flex2.core.format.amf0.type.factory.Amf0SharedObjectFactory;

public abstract class AbstractAmfObjectWriterImpl
implements Amf0DataWriter {
    private Amf0SharedObjectFactory sharedObjectFactory;
    private Amf0DataWriterFactory writerFactory;

    public void setSharedObjectFactory(Amf0SharedObjectFactory sharedObjectFactory) {
        this.sharedObjectFactory = sharedObjectFactory;
    }

    public void setWriterFactory(Amf0DataWriterFactory writerFactory) {
        this.writerFactory = writerFactory;
    }

    public void writeAmfData(Object value, DataOutputStream outputStream) throws IOException {
        int index = this.getSharedObject().getSharedIndex(value);
        if (index >= 0) {
            this.writeSharedIndex(index, outputStream);
        } else {
            this.writeObjectData(value, outputStream);
        }
    }

    protected final Amf0SharedObject getSharedObject() {
        return this.sharedObjectFactory.createSharedObject();
    }

    protected final void writeData(Object value, DataOutputStream outputStream) throws IOException {
        this.writerFactory.createDataWriter(value).writeAmfData(value, outputStream);
    }

    protected abstract void writeObjectData(Object var1, DataOutputStream var2) throws IOException;

    protected final void writeSharedIndex(int index, DataOutputStream outputStream) throws IOException {
        outputStream.writeByte(7);
        outputStream.writeShort(index);
    }
}

