/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.flex2.core.format.amf3.io.writer.impl;

import java.io.DataOutputStream;
import java.io.IOException;

public class Amf3IntWriterImpl {
    private static final int INTEGER_DATA_MASK = 127;
    private static final int INTEGER_INCLUDE_NEXT_SIGN = 128;

    protected static final void writeIntData(int value, DataOutputStream outputStream) throws IOException {
        int maskedInt = value & 0x1FFFFFFF;
        if (value < 0) {
            outputStream.writeByte(value >> 22 & 0x7F | 0x80);
            outputStream.writeByte(value >> 15 & 0x7F | 0x80);
            outputStream.writeByte(value >> 8 & 0x7F | 0x80);
            outputStream.writeByte(value & 0xFF);
        } else if (maskedInt < 128) {
            outputStream.writeByte(maskedInt);
        } else if (maskedInt < 16384) {
            outputStream.writeByte(value >> 7 & 0x7F | 0x80);
            outputStream.writeByte(value & 0x7F);
        } else if (maskedInt < 0x200000) {
            outputStream.writeByte(value >> 14 & 0x7F | 0x80);
            outputStream.writeByte(value >> 7 & 0x7F | 0x80);
            outputStream.writeByte(value & 0x7F);
        } else {
            outputStream.writeByte(value >> 22 & 0x7F | 0x80);
            outputStream.writeByte(value >> 15 & 0x7F | 0x80);
            outputStream.writeByte(value >> 8 & 0x7F | 0x80);
            outputStream.writeByte(value & 0xFF);
        }
    }
}

