/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.flex2.core.format.amf3.io.reader.impl;

import java.io.DataInputStream;
import java.io.IOException;

public class Amf3IntReaderImpl {
    protected static final int readInt(DataInputStream inputStream) throws IOException {
        int firstByte = inputStream.readUnsignedByte();
        int result = firstByte < 128 ? firstByte : Amf3IntReaderImpl.readIntData(firstByte, inputStream);
        return result;
    }

    private static final int readIntData(int firstByte, DataInputStream inputStream) throws IOException {
        int[] intBytes = new int[4];
        int intByteLength = Amf3IntReaderImpl.readIntDataBytes(firstByte, inputStream, intBytes);
        int intData = Amf3IntReaderImpl.toInt(intBytes, intByteLength);
        if (intByteLength >= 4 && firstByte >= 192) {
            intData |= 0xF0000000;
        }
        return intData;
    }

    private static final int readIntDataBytes(int firstByte, DataInputStream inputStream, int[] intBytes) throws IOException {
        int intByteLength = 1;
        intBytes[0] = firstByte & 0x7F;
        for (int i = 1; i < 4; ++i) {
            intBytes[i] = inputStream.readUnsignedByte();
            ++intByteLength;
            if (intBytes[i] >>> 7 == 0) break;
        }
        return intByteLength;
    }

    private static final int toInt(int[] list, int bytes) {
        int intValue = list[bytes - 1];
        int offset = bytes < 4 ? 7 : 8;
        for (int i = bytes - 1; i > 0; --i) {
            intValue |= (list[i - 1] & 0x7F) << offset;
            offset += 7;
        }
        return intValue;
    }
}

