package test;

import java.util.List;

import model.ClassRoom;

import org.seasar.dao.unit.S2DaoTestCase;
import org.seasar.extension.dataset.DataSet;

import dao.ClassRoomDao;

public class ClassRoomDaoTest extends S2DaoTestCase {
    
    //eXgpClassRoomCX^Xidicont@Cɐݒj
    private ClassRoom testClass;
    
	//eXgpClassRoomDaoCX^Xidicont@Cɐݒj
    private ClassRoomDao classRoomDao_;

	public ClassRoomDaoTest(String name) {
		super(name);
	}
	
	protected void setUp() throws Exception {
		super.setUp();
        include("test.classroom.dicon");
	}
    
    //insert() AfindAllClassRoom()Adelete()̃eXg
    public void testInsertAndDelete(){
        
    	//e[ȕԂ3̊bf[^邱ƂOɂĂB
    	
    	//insert()̃eXg
        classRoomDao_.insert(testClass);
        
		//ؗp̃f[^擾
        List rooms = classRoomDao_.findAllClassRoom();
        
		//eXg؂DBɏ܂ꂽǂB
		//pӂꂽ3̃R[hɒǉA4̃R[h̓eLq
        //InsertClassRoomTest.xlsɗ\ʂpӂĂ܂
        
        DataSet insertTestData = readXls("InsertClassRoomTest.xls");
        assertEquals(insertTestData,rooms);
        
        //delete()̃eXg
        classRoomDao_.delete(testClass);
        
//      ؗp̃f[^擾
        rooms = classRoomDao_.findAllClassRoom();
        
		//eXg؂DB폜ꂽǂmF
		//pӂꂽ3̃R[hɂȂ邱
        DataSet preConditionData = readXls("PreDataClassRoom.xls");
        assertEquals(preConditionData,rooms);
    }
    
    //findClassRoom()Aupdate()̃eXg
    public void testFindClassRoomAndUpdate(){
        
        //eXg̑OƂupdateNClassRoom擾
        ClassRoom room = classRoomDao_.findClassRoom(1);
        
		//XV閼Oݒ肷
        room.setName("3-A");
        
        classRoomDao_.update(room);
        
		//XVClassRoom擾
        ClassRoom updateRoom = classRoomDao_.findClassRoom(1);
        
        //eXg؂͍XVClassRoom̖OXVĂ邱
        assertEquals(updateRoom.getName(),"3-A");
        
		//eXg{Õf[^ɖ߂
        updateRoom.setName("1-A");
        classRoomDao_.update(updateRoom);
    }
    
    //findClassForStudent()̃eXg
    public void testFindClassForStudent(){

    	//e[ȕԂ9̊bf[^邱ƂOɂĂB
        List listClassRooms = classRoomDao_.findClassForStudentName("Student5");
        
        //eXǧ؃f[^Excelǂݍ
        DataSet dSet = readXls("ClassRoomForStudentNameTest.xls");
        //؃f[^ƓǂmF
        assertEquals(dSet,listClassRooms);
        
    }
    
    //updateChangeTeacher()̃eXg
    public void testUpdateChangeTeacher(){
    	
    	//OSeasar2Ƃt̂郌R[h邱
    	//̃f[^͊bf[^3Ɋ܂܂Ă
    	
    	classRoomDao_.updateChangeTeacher("Seasar2","Test1");
    	
    	//XVClassRoomCX^X擾
        ClassRoom room = classRoomDao_.findClassRoom(2);
  
        //eXǧ؂͍XṼCX^XύXeƂȂĂ邱
        assertEquals(room.getTeacher(),"Test1");
        
        //eXg{Õf[^ɖ߂
        room.setTeacher("Seasar2");
        classRoomDao_.update(room);
    }
}
