package dao;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.hsqldb.jdbcDriver;

import model.Drink;

public class DrinkDaoImpl implements DrinkDao{
	
	//HSQLDBɐڑ邽߂̏
	public static final Class DRIVERCLASS=jdbcDriver.class;
	public static final String CONNECTURL="jdbc:hsqldb:hsql://localhost";
	
	//Drinke[uɃANZXSQL
	public static final String SELECTALL = "select id,name,price,quantity,type from drink";
	public static final String UPDATE = "update drink set name = ? , price = ? , quantity = ? , type = ? where id = ?;";
	public static final String INSERT = "insert into drink values(?,?,?,?,?)";
	public static final String DELETE = "delete from drink where id = ?";
	
	//Drinke[ũJ
	private static final String ID = "id";
	private static final String NAME = "name";
	private static final String PRICE = "price";
	private static final String QUANTITY = "quantity";
	private static final String TYPE = "type";
	
	
	private Connection con;
	
	public DrinkDaoImpl() throws SQLException{
		//RXgN^DBRlNV擾
		con = DriverManager.getConnection(CONNECTURL);
	}
	
	//SȂ\bh
    public List getAllDrinks() throws SQLException{
    	PreparedStatement ps = con.prepareStatement(SELECTALL);
    	ResultSet rs = ps.executeQuery();
    	
    	List allDrinks = mappingDrinks(rs);
    	
    	rs.close();
    	ps.close();
    	
    	return allDrinks;
    }
    
    //ResultSetDrinkCX^XList𐶐郁\bh
    private List mappingDrinks(ResultSet rs) throws SQLException{
    	List allDrinks = new ArrayList();
    	
    	while(rs.next()){
    		//̃CX^X̃}bsOmappingDrink()\bhłȂ
    		allDrinks.add(mappingDrink(rs));
    	}
    	
    	return allDrinks;
    }
    
    //ƂēnꂽResultSetɂJg̈ʒȕDrinkCX^Xɐݒ肷
    private Drink mappingDrink(ResultSet rs) throws SQLException{
    	Drink drink = new Drink();
    	
    	//Drink̃CX^XDB̒lݒ肷
    	drink.setId(rs.getInt(DrinkDaoImpl.ID));
    	drink.setName(rs.getString(DrinkDaoImpl.NAME));
    	drink.setPrice(rs.getInt(DrinkDaoImpl.PRICE));
    	drink.setQuantity(rs.getInt(DrinkDaoImpl.QUANTITY));
    	drink.setType(rs.getString(DrinkDaoImpl.TYPE));
    	
    	return drink;
    }
    
    //XVp̃\bh
    public int update(Drink drink) throws SQLException{
    	PreparedStatement ps = con.prepareStatement(UPDATE);
    	
    	//XVeݒ肷
    	ps.setString(1,drink.getName());
    	ps.setInt(2,drink.getPrice());
    	ps.setInt(3,drink.getQuantity());
    	ps.setString(4,drink.getType());
    	
    	//ύXݕIDݒ肷
    	ps.setInt(5,drink.getId());
    	
    	int result = ps.executeUpdate();

	//{finallyŌĂяoׂATv̂ߊȗĂ܂B
	ps.close();
    	
    	return result;
    }
    
    //}p̃\bh
    public int insert(Drink drink) throws SQLException{
    	PreparedStatement ps = con.prepareStatement(INSERT);
    	
    	//}eݒ肷
    	ps.setInt(1,drink.getId());
    	ps.setString(2,drink.getName());
    	ps.setInt(3,drink.getQuantity());
    	ps.setString(4,drink.getType());
    	ps.setInt(5,drink.getPrice());
    	
    	int result = ps.executeUpdate();

	//{finallyŌĂяoׂATv̂ߊȗĂ܂B
	ps.close();
    	
    	return result;
    }

    //폜p̃\bh
    public int delete(Drink drink) throws SQLException{
    	PreparedStatement ps = con.prepareStatement(DELETE);
    	
    	//폜IDݒ肷
    	ps.setInt(1,drink.getId());
    	
    	int result = ps.executeUpdate();

	//{finallyŌĂяoׂATv̂ߊȗĂ܂B
	ps.close();

    	return result;
    }
    
    //DBRlNV𖾎Iɕ
    public void close(){
    	try {
			con.close();
		} catch (SQLException e) {
			e.printStackTrace();
		}
    }
    
}
