package jsf.validator;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

import org.seasar.jsf.util.MessageUtil;

public class EmailValidator implements Validator {
    public static final String EMAIL_MESSAGE_ID = "jsf.validator.Email.INVALID";

    public void validate(FacesContext facesContext, UIComponent uiComponent, Object value) throws ValidatorException {
        if (value == null) {
            return;
        }

        if (value.toString().indexOf("@") < 0) {
            Object[] args = { value.toString(), uiComponent.getId() };
            throw new ValidatorException(MessageUtil.getErrorMessage(EMAIL_MESSAGE_ID, args));
        }
    }
}
