/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.tree.model;

import java.io.Serializable;

public final class TreePath
implements Serializable {
    private Object[] elements;

    public TreePath(Object[] pathElements) {
        if (pathElements == null || pathElements.length == 0) {
            throw new IllegalArgumentException("pathElements must be non null and not empty");
        }
        this.elements = pathElements;
    }

    protected TreePath(TreePath parent, Object lastElement) {
        this.elements = new Object[parent.elements.length + 1];
        System.arraycopy(parent.elements, 0, this.elements, 0, this.elements.length - 1);
        this.elements[this.elements.length - 1] = lastElement;
    }

    protected TreePath(Object[] pathElements, int length) {
        Object[] elements = new Object[length];
        System.arraycopy(pathElements, 0, elements, 0, length);
    }

    public Object[] getPath() {
        Object[] answer = new Object[this.elements.length];
        System.arraycopy(this.elements, 0, answer, 0, this.elements.length);
        return answer;
    }

    public Object getLastPathComponent() {
        return this.elements[this.elements.length - 1];
    }

    public int getPathCount() {
        return this.elements.length;
    }

    public Object getPathComponent(int index) {
        if (index < 0 || index >= this.elements.length) {
            throw new IllegalArgumentException("Index " + index + " is out of range");
        }
        return this.elements[index];
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TreePath)) {
            return false;
        }
        TreePath other = (TreePath)o;
        if (this.elements.length != other.elements.length) {
            return false;
        }
        for (int i = 0; i < this.elements.length; ++i) {
            Object thisElement = this.elements[i];
            Object otherElement = other.elements[i];
            if (thisElement.equals(otherElement)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.elements[this.elements.length - 1].hashCode();
    }

    public boolean isDescendant(TreePath path) {
        if (path == null) {
            return false;
        }
        if (this.elements.length < path.elements.length) {
            return false;
        }
        for (int i = 0; i < this.elements.length; ++i) {
            Object thisElement = this.elements[i];
            Object otherElement = path.elements[i];
            if (thisElement.equals(otherElement)) continue;
            return false;
        }
        return true;
    }

    public TreePath pathByAddingChild(Object child) {
        if (child == null) {
            throw new NullPointerException("Null child not allowed");
        }
        return new TreePath(this, child);
    }

    public TreePath getParentPath() {
        return new TreePath(this.elements, this.elements.length - 1);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("[");
        for (int i = 0; i < this.elements.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.elements[i]);
        }
        buffer.append("]");
        return buffer.toString();
    }
}

