package samples.dbcp;

import java.sql.SQLException;

import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerFactory;

public class EmployeeClientForMeasurement {

	private static final String PATH = "samples/dbcp/Employee.dicon";
	private static final int MAX = 1000;
	
	public static void main(String[] args) {
		S2Container container = S2ContainerFactory.create(PATH);
		container.init();
		try {
			long start = System.currentTimeMillis();
			for (int i = 0; i < MAX; i++) {
				EmployeeService service = (EmployeeService) container
					.getComponent(EmployeeService.class);
				service.getEmployeeName(7788);
			}
			System.out.println("time[ms]: " + (System.currentTimeMillis() - start));
		} catch (SQLException ex) {
			ex.printStackTrace();
		} finally {
			container.destroy();
		}
	}
}