package seasar2.sample;

import org.seasar.extension.unit.S2TestCase;
import org.seasar.framework.aop.interceptors.MockInterceptor;

/**
 * MockInterceptorgProductModel̒P̃eXg
 */
public class ProductModelTest extends S2TestCase {

    private ProductModel productModel;

	private MockInterceptor mi = new MockInterceptor();


	public ProductModelTest(String arg) {
		super(arg);
	}
	
	protected void setUp() throws Exception {
		super.setUp();
		include("product.dicon");
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/**
	 * iP100~A10ɑ΂čvz1000~ł邱ƂmF
	 * ProductDAO#findByPrimaryKey(String)Ă΂邱ƂmF
	 * ProductDAO#findByPrimaryKey(String)̈̒lɐiId001ZbgĂ邱ƂmF
	 */
	public void testCalcTotalPrice() throws Exception{
		productModel.setProductDAO(createMockProductDAO(100));
		assertEquals(1000, productModel.calcTotalPrice("001", 10));
		assertTrue(mi.isInvoked("findByPrimaryKey"));
		assertEquals("001", mi.getArgs("findByPrimaryKey")[0]);
	}

	/**
	 * iP0~()A10ɑ΂čvz0~ł邱ƂmF
	 */
	public void testCalcTotalPrice2() throws Exception{
		productModel.setProductDAO(createMockProductDAO(0));
		assertEquals(0, productModel.calcTotalPrice("001", 10));
	}

	/**
	 * iP100~A0ɑ΂IllegalArgumentExceptionX[邱ƂmF
	 * ProductDAO#findByPrimaryKey(String)Ă΂ȂƂmF
	 */
	public void testIllegalCalcTotalPrice() throws Exception{
		try{
			productModel.setProductDAO(createMockProductDAO(100));
			productModel.calcTotalPrice("001", 0);
			fail();
		}catch(IllegalArgumentException e){}
		assertFalse(mi.isInvoked("findByPrimaryKey"));
	}

	/**
	 * ProductDAÕbN𐶐܂B
	 * @param unitPrice iPi~j
	 * @return ProductDAÕbN
	 */
	private ProductDAO createMockProductDAO(int unitPrice) {
		Product product = new Product();
		product.setUnitPrice(unitPrice);
		mi.setReturnValue("findByPrimaryKey", product);
		ProductDAO productDAO = (ProductDAO) mi.createProxy(ProductDAO.class);
		return productDAO;
	}
	
}
